/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.collect;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import org.jclouds.collect.PaginatedSet;

@Beta
public class PaginatedSets {
    public static <T> Iterable<T> lazyContinue(final PaginatedSet<T> initial, final Function<String, PaginatedSet<T>> markerToNext) {
        if (initial.getNextMarker() == null) {
            return initial;
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new AbstractIterator<T>(){
                    private PaginatedSet<T> response;
                    private Iterator<T> iterator;
                    {
                        this.response = initial;
                        this.iterator = this.response.iterator();
                    }

                    protected T computeNext() {
                        while (true) {
                            if (this.iterator == null) {
                                this.response = (PaginatedSet)((Object)markerToNext.apply((Object)this.response.getNextMarker()));
                                this.iterator = this.response.iterator();
                            }
                            if (this.iterator.hasNext()) {
                                return this.iterator.next();
                            }
                            if (this.response.getNextMarker() == null) {
                                return this.endOfData();
                            }
                            this.iterator = null;
                        }
                    }
                };
            }

            public String toString() {
                return "lazyContinue(" + markerToNext.toString() + ")";
            }
        };
    }
}

