/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cache.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ForwardingObject;
import java.util.concurrent.Callable;
import org.jclouds.util.Throwables2;

@Beta
class BackoffExponentiallyAndRetryOnThrowableCallable<T>
extends ForwardingObject
implements Callable<T> {
    private final Class<? extends Throwable> retryableThrowable;
    private final long periodMs;
    private final long maxPeriodMs;
    private final int maxTries;
    private final Callable<T> callable;

    BackoffExponentiallyAndRetryOnThrowableCallable(Class<? extends Throwable> retryableThrowable, long periodMs, long maxPeriodMs, int maxTries, Callable<T> callable) {
        this.retryableThrowable = (Class)Preconditions.checkNotNull(retryableThrowable, (Object)"retryableThrowable");
        Preconditions.checkArgument((maxTries > 1 ? 1 : 0) != 0, (String)"maxTries must be more than one: %d", (Object[])new Object[]{maxTries});
        this.maxTries = maxTries;
        Preconditions.checkArgument((periodMs > 0L ? 1 : 0) != 0, (String)"periodMs must be positive: %d", (Object[])new Object[]{periodMs});
        this.periodMs = periodMs;
        Preconditions.checkArgument((maxPeriodMs > periodMs ? 1 : 0) != 0, (String)"maxPeriodMs must be equal to or greater than periodMs: %d %d", (Object[])new Object[]{maxPeriodMs, periodMs});
        this.maxPeriodMs = maxPeriodMs;
        this.callable = (Callable)Preconditions.checkNotNull(callable, (Object)"callable");
    }

    protected Callable<T> delegate() {
        return this.callable;
    }

    @Override
    public T call() throws Exception {
        Exception currentException = null;
        for (int currentTries = 0; currentTries < this.maxTries; ++currentTries) {
            try {
                return (T)this.delegate().call();
            }
            catch (Exception e) {
                currentException = e;
                if (Throwables2.getFirstThrowableOfType(e, this.retryableThrowable) == null) {
                    throw e;
                }
                this.imposeBackoffExponentialDelay(this.periodMs, this.maxPeriodMs, 2, currentTries, this.maxTries);
                continue;
            }
        }
        throw currentException;
    }

    void imposeBackoffExponentialDelay(long period, long maxPeriod, int pow, int failureCount, int max) {
        long delayMs = (long)((double)period * Math.pow(failureCount, pow));
        delayMs = delayMs > maxPeriod ? maxPeriod : delayMs;
        try {
            Thread.sleep(delayMs);
        }
        catch (InterruptedException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("retryableThrowable", this.retryableThrowable).add("periodMs", this.periodMs).add("maxPeriodMs", this.maxPeriodMs).add("maxTries", this.maxTries).add("callable", this.callable).toString();
    }
}

