/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cache;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import org.jclouds.cache.internal.BackoffExponentiallyAndRetryOnThrowableCacheLoader;

@Beta
public class RetryingCacheLoaderDecorator<K, V> {
    protected RetryingCacheLoaderDecorator() {
    }

    public static RetryingCacheLoaderDecorator<Object, Object> newDecorator() {
        return new RetryingCacheLoaderDecorator<Object, Object>();
    }

    public OnThrowableBuilder<K, V> on(Class<? extends Throwable> retryableThrowable) {
        return new OnThrowableBuilder(retryableThrowable);
    }

    public <K1 extends K, V1 extends V> CacheLoader<K1, V1> decorate(CacheLoader<K1, V1> loader) {
        return loader;
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this);
    }

    public static class BackoffExponentiallyAndRetryOnThrowableCacheLoaderDecorator<K, V>
    extends RetryingCacheLoaderDecorator<K, V> {
        private long periodMs = 100L;
        private long maxPeriodMs = 200L;
        private int maxTries = 5;
        private final Class<? extends Throwable> retryableThrowable;

        protected BackoffExponentiallyAndRetryOnThrowableCacheLoaderDecorator(Class<? extends Throwable> retryableThrowable) {
            this.retryableThrowable = (Class)Preconditions.checkNotNull(retryableThrowable, (Object)"retryableThrowable");
        }

        public BackoffExponentiallyAndRetryOnThrowableCacheLoaderDecorator<K, V> periodMs(long periodMs) {
            Preconditions.checkArgument((periodMs > 1L ? 1 : 0) != 0, (String)"maxTries must be positive: %d", (Object[])new Object[]{periodMs});
            this.periodMs = periodMs;
            return this;
        }

        public BackoffExponentiallyAndRetryOnThrowableCacheLoaderDecorator<K, V> maxPeriodMs(long maxPeriodMs) {
            Preconditions.checkArgument((maxPeriodMs > this.periodMs ? 1 : 0) != 0, (String)"maxPeriodMs must be equal to or greater than periodMs: %d %d", (Object[])new Object[]{maxPeriodMs, this.periodMs});
            this.maxPeriodMs = maxPeriodMs;
            return this;
        }

        public BackoffExponentiallyAndRetryOnThrowableCacheLoaderDecorator<K, V> maxTries(int maxTries) {
            Preconditions.checkArgument((maxTries > 1 ? 1 : 0) != 0, (String)"maxTries must be more than one: %d", (Object[])new Object[]{maxTries});
            this.maxTries = maxTries;
            return this;
        }

        @Override
        public <K1 extends K, V1 extends V> CacheLoader<K1, V1> decorate(CacheLoader<K1, V1> loader) {
            return new BackoffExponentiallyAndRetryOnThrowableCacheLoader<K1, V1>(this.retryableThrowable, this.periodMs, this.maxPeriodMs, this.maxTries, super.decorate(loader));
        }

        @Override
        protected Objects.ToStringHelper string() {
            return this.string().add("retryableThrowable", this.retryableThrowable).add("periodMs", this.periodMs).add("maxPeriodMs", this.maxPeriodMs).add("maxTries", this.maxTries);
        }
    }

    public static class OnThrowableBuilder<K, V> {
        Class<? extends Throwable> retryableThrowable;

        protected OnThrowableBuilder(Class<? extends Throwable> retryableThrowable) {
            this.retryableThrowable = (Class)Preconditions.checkNotNull(retryableThrowable, (Object)"retryableThrowable");
        }

        public BackoffExponentiallyAndRetryOnThrowableCacheLoaderDecorator<K, V> exponentiallyBackoff() {
            return new BackoffExponentiallyAndRetryOnThrowableCacheLoaderDecorator(this.retryableThrowable);
        }
    }
}

