/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.lb.common.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.carbon.lb.common.dao.AbstractDAO;

public class InstanceDAO
extends AbstractDAO {
    private Connection con = null;
    private String url = "jdbc:mysql://localhost:3306/";
    private String db = "hosting_mgt_db";
    private String driver = "com.mysql.jdbc.Driver";
    private String dbUsername = "root";
    private String dbPassword = "root";
    private Statement statement = null;

    public HashMap<String, ArrayList<String>> getDomainToInstanceIdsMap() throws SQLException {
        HashMap<String, ArrayList<String>> instanceToDomainMap = new HashMap<String, ArrayList<String>>();
        ResultSet resultSet = null;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sql = "SELECT instance_id, domain FROM instance";
            resultSet = this.statement.executeQuery(sql);
            ArrayList<Object> instanceList = null;
            while (resultSet.next()) {
                String domain = resultSet.getString("domain");
                String instanceId = resultSet.getString("instance_id");
                instanceList = new ArrayList<String>();
                if (!instanceToDomainMap.containsKey(domain)) {
                    instanceList.add(instanceId);
                } else {
                    ArrayList<String> instanceListObject = instanceToDomainMap.get(domain);
                    if (instanceListObject instanceof ArrayList) {
                        instanceList = instanceListObject;
                        instanceList.add(instanceId);
                    } else {
                        String msg = "Unable to retrieve instance array";
                        throw new ClassCastException(msg);
                    }
                }
                instanceToDomainMap.put(domain, instanceList);
            }
        }
        catch (SQLException s) {
            String msg = "Error while getting available ip " + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "Error while sql connection :" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(msg);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
        return instanceToDomainMap;
    }

    public HashMap<String, String> getInstanceIdToAdapterMap() throws SQLException {
        HashMap<String, String> instanceToAdapterMap = new HashMap<String, String>();
        ResultSet resultSet = null;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sql = "SELECT instance_id, adapter FROM instance";
            resultSet = this.statement.executeQuery(sql);
            while (resultSet.next()) {
                String adapter = resultSet.getString("adapter");
                String instanceId = resultSet.getString("instance_id");
                instanceToAdapterMap.put(instanceId, adapter);
            }
        }
        catch (SQLException s) {
            String msg = "Error while getting adapter map " + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "Error while sql connection :" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(msg);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
        return instanceToAdapterMap;
    }

    public boolean add(String instance, String adapter, String domain) throws SQLException {
        boolean successfullyAdded = false;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sql = "INSERT INTO instance VALUES('" + instance + "', '" + adapter + "', '" + domain + "')";
            this.statement.executeUpdate(sql);
            successfullyAdded = true;
        }
        catch (SQLException s) {
            String msg = "Error while inserting instance data";
            this.log.error((Object)(msg + s.getMessage()));
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "DB connection not successful !";
            this.log.error((Object)msg);
            throw new SQLException(msg);
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
        return successfullyAdded;
    }

    public boolean delete(String instanceId) throws SQLException {
        boolean successfullyDeleted = false;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sql = "UPDATE instance SET deleted=trueWHERE instance_id='" + instanceId + "'";
            this.statement.executeUpdate(sql);
            successfullyDeleted = true;
        }
        catch (SQLException s) {
            String msg = "Error while deleting instance data";
            this.log.error((Object)(msg + s.getMessage()));
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "DB connection not successful !";
            this.log.error((Object)msg);
            throw new SQLException(msg);
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
        return successfullyDeleted;
    }
}

