/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.lb.common.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.wso2.carbon.lb.common.dao.AbstractDAO;

public class EC2DAO
extends AbstractDAO {
    private Connection con = null;
    private String url = "jdbc:mysql://localhost:3306/";
    private String db = "hosting_mgt_db";
    private String driver = "com.mysql.jdbc.Driver";
    private String dbUsername = "root";
    private String dbPassword = "root";
    private Statement statement = null;

    public HashMap<String, String> getUuidToEC2IdMap() throws SQLException {
        HashMap<String, String> uuidToEc2IdMap = new HashMap<String, String>();
        ResultSet resultSet = null;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sql = "SELECT * FROM ec2_instance";
            resultSet = this.statement.executeQuery(sql);
            while (resultSet.next()) {
                String uuid = resultSet.getString("uuid");
                String ec2Id = resultSet.getString("ec2_id");
                uuidToEc2IdMap.put(uuid, ec2Id);
            }
        }
        catch (SQLException s) {
            String msg = "Error while getting Uuid  to ec2 map " + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "Error while sql connection :" + s.getMessage();
            this.log.error((Object)msg);
            throw new SQLException(msg);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
        return uuidToEc2IdMap;
    }

    public boolean add(String uuid, String ec2Id) throws SQLException {
        boolean successfullyAdded = false;
        ResultSet resultSet = null;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sql = "INSERT INTO ec2_instance VALUES('" + uuid + "', '" + ec2Id + "'," + false + ")";
            this.statement.executeUpdate(sql);
            successfullyAdded = true;
        }
        catch (SQLException s) {
            String msg = "Error while inserting EC2 instance data";
            this.log.error((Object)(msg + s.getMessage()));
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "DB connection not successful !";
            this.log.error((Object)msg);
            throw new SQLException(msg);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
        return successfullyAdded;
    }

    public boolean delete(String uuid) throws SQLException {
        boolean successfullyDeleted = false;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url + this.db, this.dbUsername, this.dbPassword);
            this.statement = this.con.createStatement();
            String sql = "UPDATE ec2_instance SET deleted=trueWHERE uuid='" + uuid + "'";
            this.statement.executeUpdate(sql);
            successfullyDeleted = true;
        }
        catch (SQLException s) {
            String msg = "Error while deleting EC2 instance data";
            this.log.error((Object)(msg + s.getMessage()));
            throw new SQLException(s + msg);
        }
        catch (ClassNotFoundException s) {
            String msg = "DB connection not successful !";
            this.log.error((Object)msg);
            throw new SQLException(msg);
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {}
        }
        return successfullyDeleted;
    }
}

