/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.aws.ec2.domain.LaunchSpecification;
import org.jclouds.ec2.domain.BlockDeviceMapping;
import org.jclouds.ec2.options.RunInstancesOptions;

public class AWSRunInstancesOptions
extends RunInstancesOptions {
    private LaunchSpecification.Builder launchSpecificationBuilder = LaunchSpecification.builder();
    public static final AWSRunInstancesOptions NONE = new AWSRunInstancesOptions();

    public AWSRunInstancesOptions inPlacementGroup(String placementGroup) {
        this.formParameters.put((Object)"Placement.GroupName", Preconditions.checkNotNull((Object)placementGroup, (Object)"placementGroup"));
        return this;
    }

    public AWSRunInstancesOptions enableMonitoring() {
        this.formParameters.put((Object)"Monitoring.Enabled", (Object)"true");
        this.launchSpecificationBuilder.monitoringEnabled(true);
        return this;
    }

    public AWSRunInstancesOptions withSubnetId(String subnetId) {
        this.formParameters.put((Object)"SubnetId", Preconditions.checkNotNull((Object)subnetId, (Object)"subnetId"));
        return this;
    }

    public AWSRunInstancesOptions withSecurityGroupId(String securityGroup) {
        return this.withSecurityGroupIds(securityGroup);
    }

    public AWSRunInstancesOptions withSecurityGroupIds(Iterable<String> securityGroupIds) {
        this.launchSpecificationBuilder.securityGroupIds(securityGroupIds);
        this.indexFormValuesWithPrefix("SecurityGroupId", securityGroupIds);
        return this;
    }

    public AWSRunInstancesOptions withSecurityGroupIds(String ... securityGroupIds) {
        return this.withSecurityGroupIds((Iterable<String>)ImmutableSet.copyOf((Object[])securityGroupIds));
    }

    public AWSRunInstancesOptions withBlockDeviceMappings(Set<? extends BlockDeviceMapping> mappings) {
        this.launchSpecificationBuilder.blockDeviceMappings(mappings);
        return (AWSRunInstancesOptions)((Object)AWSRunInstancesOptions.class.cast(super.withBlockDeviceMappings(mappings)));
    }

    public AWSRunInstancesOptions withKernelId(String kernelId) {
        this.launchSpecificationBuilder.kernelId(kernelId);
        return (AWSRunInstancesOptions)((Object)AWSRunInstancesOptions.class.cast(super.withKernelId(kernelId)));
    }

    public AWSRunInstancesOptions withKeyName(String keyName) {
        this.launchSpecificationBuilder.keyName(keyName);
        return (AWSRunInstancesOptions)((Object)AWSRunInstancesOptions.class.cast(super.withKeyName(keyName)));
    }

    public AWSRunInstancesOptions withRamdisk(String ramDiskId) {
        this.launchSpecificationBuilder.ramdiskId(ramDiskId);
        return (AWSRunInstancesOptions)((Object)AWSRunInstancesOptions.class.cast(super.withRamdisk(ramDiskId)));
    }

    public AWSRunInstancesOptions withSecurityGroup(String securityGroup) {
        this.launchSpecificationBuilder.securityGroupName(securityGroup);
        return (AWSRunInstancesOptions)((Object)AWSRunInstancesOptions.class.cast(super.withSecurityGroup(securityGroup)));
    }

    public AWSRunInstancesOptions withSecurityGroups(Iterable<String> securityGroups) {
        this.launchSpecificationBuilder.securityGroupNames(securityGroups);
        return (AWSRunInstancesOptions)((Object)AWSRunInstancesOptions.class.cast(super.withSecurityGroups(securityGroups)));
    }

    public AWSRunInstancesOptions withSecurityGroups(String ... securityGroups) {
        this.launchSpecificationBuilder.securityGroupNames((Iterable<String>)ImmutableSet.copyOf((Object[])securityGroups));
        return (AWSRunInstancesOptions)((Object)AWSRunInstancesOptions.class.cast(super.withSecurityGroups(securityGroups)));
    }

    public AWSRunInstancesOptions withUserData(byte[] unencodedData) {
        this.launchSpecificationBuilder.userData(unencodedData);
        return (AWSRunInstancesOptions)((Object)AWSRunInstancesOptions.class.cast(super.withUserData(unencodedData)));
    }

    public AWSRunInstancesOptions asType(String type) {
        this.launchSpecificationBuilder.instanceType(type);
        return (AWSRunInstancesOptions)((Object)AWSRunInstancesOptions.class.cast(super.asType(type)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized LaunchSpecification.Builder getLaunchSpecificationBuilder() {
        try {
            LaunchSpecification.Builder builder = this.launchSpecificationBuilder.imageId("fake").build().toBuilder().imageId(null);
            return builder;
        }
        finally {
            this.launchSpecificationBuilder.imageId(null);
        }
    }

    public static class Builder
    extends RunInstancesOptions.Builder {
        public static AWSRunInstancesOptions withSecurityGroupId(String securityGroup) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withSecurityGroupId(securityGroup);
        }

        public static AWSRunInstancesOptions inPlacementGroup(String placementGroup) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.inPlacementGroup(placementGroup);
        }

        public static AWSRunInstancesOptions enableMonitoring() {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.enableMonitoring();
        }

        public static AWSRunInstancesOptions withSubnetId(String subnetId) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withSubnetId(subnetId);
        }

        public static AWSRunInstancesOptions withKeyName(String keyName) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withKeyName(keyName);
        }

        public static AWSRunInstancesOptions withSecurityGroup(String securityGroup) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withSecurityGroup(securityGroup);
        }

        public static AWSRunInstancesOptions withUserData(byte[] unencodedData) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withUserData(unencodedData);
        }

        public static AWSRunInstancesOptions asType(String instanceType) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.asType(instanceType);
        }

        public static AWSRunInstancesOptions withKernelId(String kernelId) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withKernelId(kernelId);
        }

        public static AWSRunInstancesOptions withRamdisk(String ramdiskId) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withRamdisk(ramdiskId);
        }

        public static AWSRunInstancesOptions withBlockDeviceMappings(Set<? extends BlockDeviceMapping> mappings) {
            AWSRunInstancesOptions options = new AWSRunInstancesOptions();
            return options.withBlockDeviceMappings((Set)mappings);
        }
    }
}

