/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.autoscaler.service.xml;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.autoscaler.service.exception.MalformedConfigurationFileException;
import org.wso2.carbon.autoscaler.service.util.IaasProvider;
import org.wso2.carbon.autoscaler.service.util.ServiceTemplate;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class ElasticScalerConfigFileReader {
    private static final Log log = LogFactory.getLog(ElasticScalerConfigFileReader.class);
    private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private Document dom;
    private Element docEle;
    private String elasticScalerConfigFile;

    public ElasticScalerConfigFileReader() {
        this.elasticScalerConfigFile = CarbonUtils.getCarbonConfigDirPath() + File.separator + "elastic-scaler-config.xml";
        try {
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            this.dom = db.parse(this.elasticScalerConfigFile);
        }
        catch (Exception ex) {
            String msg = "Error occurred while parsing the " + this.elasticScalerConfigFile + ".";
            this.handleException(msg, ex);
        }
    }

    public ElasticScalerConfigFileReader(String file) {
        try {
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            this.dom = db.parse(file);
        }
        catch (Exception ex) {
            String msg = "Error occurred when parsing the " + file + ".";
            this.handleException(msg, ex);
        }
    }

    public String getSerializationDir() {
        this.docEle = this.dom.getDocumentElement();
        NodeList nl = this.docEle.getElementsByTagName("serializationDir");
        if (nl != null && nl.getLength() > 0 && nl.item(0).getNodeType() == 1) {
            Element prop = (Element)nl.item(0);
            return prop.getTextContent();
        }
        return "";
    }

    public List<IaasProvider> getIaasProvidersList() {
        ArrayList<IaasProvider> iaasProviders = new ArrayList<IaasProvider>();
        this.docEle = this.dom.getDocumentElement();
        NodeList nl = this.docEle.getElementsByTagName("iaasProvider");
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                iaasProviders.add(this.getIaasProvider(nl.item(i)));
            }
        } else {
            String msg = "Essential 'iaasProvider' element cannot be found in " + this.elasticScalerConfigFile;
            this.handleException(msg);
        }
        return iaasProviders;
    }

    private IaasProvider getIaasProvider(Node item) {
        IaasProvider iaas = new IaasProvider();
        if (item.getNodeType() == 1) {
            Element iaasElt = (Element)item;
            iaas.setType(iaasElt.getAttribute("type"));
            if ("".equals(iaas.getType())) {
                String msg = "'iaasProvider' element's 'type' attribute should be specified!";
                this.handleException(msg);
            }
            iaas.setName(iaasElt.getAttribute("name"));
            iaas.setProperties(this.loadProperties(iaasElt));
            this.loadTemplate(iaas, iaasElt);
            this.loadScalingOrders(iaas, iaasElt);
            this.loadProvider(iaas, iaasElt);
            this.loadIdentity(iaas, iaasElt);
            this.loadCredentials(iaas, iaasElt);
        }
        return iaas;
    }

    public List<ServiceTemplate> getTemplates() {
        Node item;
        ArrayList<ServiceTemplate> templates = new ArrayList<ServiceTemplate>();
        ServiceTemplate template = new ServiceTemplate();
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("default");
        if (nl != null && nl.getLength() > 0 && (item = nl.item(0)).getNodeType() == 1) {
            Element defaultElt = (Element)item;
            template.setProperties(this.loadProperties(defaultElt));
        }
        if ((nl = docEle.getElementsByTagName("service")) != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node item2 = nl.item(i);
                try {
                    ServiceTemplate temp = (ServiceTemplate)template.clone();
                    if (item2.getNodeType() == 1) {
                        Element imageElt = (Element)item2;
                        if ("".equals(imageElt.getAttribute("domain"))) {
                            String msg = "Essential 'domain' attribute of 'service' element cannot be found in " + this.elasticScalerConfigFile;
                            this.handleException(msg);
                        }
                        temp.setDomainName(imageElt.getAttribute("domain"));
                        Map<String, String> customProperties = this.loadProperties(imageElt);
                        for (Map.Entry<String, String> pair : customProperties.entrySet()) {
                            temp.setProperty(pair.getKey(), pair.getValue());
                        }
                    }
                    templates.add(temp);
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    String msg = "This is extraordinary!! ";
                    this.handleException(msg, e);
                }
            }
        }
        return templates;
    }

    private void loadCredentials(IaasProvider iaas, Element iaasElt) {
        NodeList nl = iaasElt.getElementsByTagName("credential");
        if (nl != null && nl.getLength() > 0) {
            if (nl.getLength() > 1) {
                log.warn((Object)(this.elasticScalerConfigFile + " contains more than one " + "credential" + " elements!" + " Elements other than the first will be neglected."));
            }
            if (nl.item(0).getNodeType() == 1) {
                SecretResolver secretResolver = SecretResolverFactory.create((Element)this.docEle, (boolean)false);
                String alias = iaas.getProvider().contains("ec2") ? "elastic.scaler.ec2.credential" : "elastic.scaler.openstack.credential";
                if (secretResolver != null && secretResolver.isInitialized() && secretResolver.isTokenProtected(alias)) {
                    iaas.setCredential(secretResolver.resolve(alias));
                }
            }
        } else {
            String msg = "Essential 'credential' element has not specified in " + this.elasticScalerConfigFile;
            this.handleException(msg);
        }
    }

    private void loadIdentity(IaasProvider iaas, Element iaasElt) {
        NodeList nl = iaasElt.getElementsByTagName("identity");
        if (nl != null && nl.getLength() > 0) {
            if (nl.getLength() > 1) {
                log.warn((Object)(this.elasticScalerConfigFile + " contains more than one " + "identity" + " elements!" + " Elements other than the first will be neglected."));
            }
            if (nl.item(0).getNodeType() == 1) {
                SecretResolver secretResolver = SecretResolverFactory.create((Element)this.docEle, (boolean)false);
                String alias = iaas.getProvider().contains("ec2") ? "elastic.scaler.ec2.identity" : "elastic.scaler.openstack.identity";
                if (secretResolver != null && secretResolver.isInitialized() && secretResolver.isTokenProtected(alias)) {
                    iaas.setIdentity(secretResolver.resolve(alias));
                }
            }
        } else {
            String msg = "Essential 'identity' element has not specified in " + this.elasticScalerConfigFile;
            this.handleException(msg);
        }
    }

    private void loadProvider(IaasProvider iaas, Element iaasElt) {
        NodeList nl = iaasElt.getElementsByTagName("provider");
        if (nl != null && nl.getLength() > 0) {
            if (nl.getLength() > 1) {
                log.warn((Object)(this.elasticScalerConfigFile + " contains more than one " + "provider" + " elements!" + " Elements other than the first will be neglected."));
            }
            if (nl.item(0).getNodeType() == 1) {
                Element prop = (Element)nl.item(0);
                iaas.setProvider(prop.getTextContent());
            }
        } else {
            String msg = "Essential 'provider' element has not specified in " + this.elasticScalerConfigFile;
            this.handleException(msg);
        }
    }

    private void loadScalingOrders(IaasProvider iaas, Element iaasElt) {
        String msg;
        String msg2;
        Element prop;
        NodeList nl = iaasElt.getElementsByTagName("scaleUpOrder");
        if (nl != null && nl.getLength() > 0) {
            if (nl.getLength() > 1) {
                log.warn((Object)(this.elasticScalerConfigFile + " contains more than one " + "scaleUpOrder" + " elements!" + " Elements other than the first will be neglected."));
            }
            if (nl.item(0).getNodeType() == 1) {
                prop = (Element)nl.item(0);
                try {
                    iaas.setScaleUpOrder(Integer.parseInt(prop.getTextContent()));
                }
                catch (NumberFormatException e) {
                    msg2 = "scaleUpOrder element contained in " + this.elasticScalerConfigFile + "" + " has a value which is not an Integer value.";
                    this.handleException(msg2, e);
                }
            }
        } else {
            msg = "Essential 'scaleUpOrder' element has not specified in " + this.elasticScalerConfigFile;
            this.handleException(msg);
        }
        if ((nl = iaasElt.getElementsByTagName("scaleDownOrder")) != null && nl.getLength() > 0) {
            if (nl.getLength() > 1) {
                log.warn((Object)(this.elasticScalerConfigFile + " contains more than one " + "scaleDownOrder" + " elements!" + " Elements other than the first will be neglected."));
            }
            if (nl.item(0).getNodeType() == 1) {
                prop = (Element)nl.item(0);
                try {
                    iaas.setScaleDownOrder(Integer.parseInt(prop.getTextContent()));
                }
                catch (NumberFormatException e) {
                    msg2 = "scaleDownOrder element contained in " + this.elasticScalerConfigFile + "" + " has a value which is not an Integer value.";
                    this.handleException(msg2, e);
                }
            }
        } else {
            msg = "Essential 'scaleDownOrder' element has not specified in " + this.elasticScalerConfigFile;
            this.handleException(msg);
        }
    }

    private void loadTemplate(IaasProvider iaas, Element iaasElt) {
        NodeList nl = iaasElt.getElementsByTagName("imageId");
        if (nl != null && nl.getLength() > 0) {
            if (nl.getLength() > 1) {
                log.warn((Object)(this.elasticScalerConfigFile + " contains more than one " + "imageId" + " elements!" + " Elements other than the first will be neglected."));
            }
            if (nl.item(0).getNodeType() == 1) {
                Element prop = (Element)nl.item(0);
                iaas.setTemplate(prop.getTextContent());
            }
        } else {
            String msg = "Essential 'imageId' element has not specified in " + this.elasticScalerConfigFile;
            this.handleException(msg);
        }
    }

    private Map<String, String> loadProperties(Element iaasElt) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        NodeList nl = iaasElt.getElementsByTagName("property");
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                if (nl.item(i).getNodeType() != 1) continue;
                Element prop = (Element)nl.item(i);
                if ("".equals(prop.getAttribute("name")) || "".equals(prop.getAttribute("value"))) {
                    String msg = "Property element's, name and value attributes should be specified in " + this.elasticScalerConfigFile;
                    this.handleException(msg);
                }
                propertyMap.put(prop.getAttribute("name"), prop.getAttribute("value"));
            }
        }
        return propertyMap;
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new MalformedConfigurationFileException(msg);
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new MalformedConfigurationFileException(msg, e);
    }
}

