/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.autoscaler.service.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.Template;
import org.wso2.carbon.autoscaler.service.impl.AutoscalerServiceImpl;

public class IaasContext
implements Serializable {
    private static final long serialVersionUID = -922284976926131383L;
    private Enum<AutoscalerServiceImpl.Iaases> name;
    private transient Map<String, Template> domainToTemplateMap;
    private transient ComputeService computeService;
    private Map<String, String> nodeIdToDomainMap = new LinkedHashMap<String, String>();
    private Map<String, String> publicIpToDomainMap = new LinkedHashMap<String, String>();
    private Map<String, String> publicIpToNodeIdMap = new LinkedHashMap<String, String>();
    private int scaleUpOrder;
    private int scaleDownOrder;

    public IaasContext(Enum<AutoscalerServiceImpl.Iaases> name, ComputeService computeService) {
        this.name = name;
        this.computeService = computeService;
        this.domainToTemplateMap = new HashMap<String, Template>();
    }

    public Enum<AutoscalerServiceImpl.Iaases> getName() {
        return this.name;
    }

    public void addToDomainToTemplateMap(String key, Template value) {
        this.domainToTemplateMap.put(key, value);
    }

    public Template getTemplate(String key) {
        return this.domainToTemplateMap.get(key);
    }

    public ComputeService getComputeService() {
        return this.computeService;
    }

    public void setComputeService(ComputeService computeService) {
        this.computeService = computeService;
    }

    public void addNodeIdToDomainMap(String nodeId, String domain) {
        this.nodeIdToDomainMap.put(nodeId, domain);
    }

    public void addPublicIpToDomainMap(String ip, String domain) {
        this.publicIpToDomainMap.put(ip, domain);
    }

    public void addPublicIpToNodeIdMap(String ip, String nodeId) {
        this.publicIpToNodeIdMap.put(ip, nodeId);
    }

    public String getLastMatchingNode(String domain) {
        ListIterator<Map.Entry<String, String>> iter = new ArrayList<Map.Entry<String, String>>(this.nodeIdToDomainMap.entrySet()).listIterator(this.nodeIdToDomainMap.size());
        while (iter.hasPrevious()) {
            Map.Entry<String, String> entry = iter.previous();
            if (!entry.getValue().equals(domain)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getLastMatchingPublicIp(String domain) {
        ListIterator<Map.Entry<String, String>> iter = new ArrayList<Map.Entry<String, String>>(this.publicIpToDomainMap.entrySet()).listIterator(this.publicIpToDomainMap.size());
        while (iter.hasPrevious()) {
            Map.Entry<String, String> entry = iter.previous();
            if (!entry.getValue().equals(domain)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getFirstMatchingNode(String domain) {
        for (Map.Entry<String, String> entry : this.nodeIdToDomainMap.entrySet()) {
            if (!entry.getValue().equals(domain)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getNodeWithPublicIp(String publicIp) {
        for (String node : this.publicIpToNodeIdMap.keySet()) {
            if (!node.equals(publicIp)) continue;
            return this.publicIpToNodeIdMap.get(node);
        }
        return null;
    }

    public List<String> getNodeIds(String domain) {
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.nodeIdToDomainMap.entrySet()) {
            if (!entry.getValue().equals(domain)) continue;
            nodeIds.add(entry.getKey());
        }
        return nodeIds;
    }

    public void removeNodeId(String nodeId) {
        this.nodeIdToDomainMap.remove(nodeId);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IaasContext) {
            return new EqualsBuilder().append(this.getName(), ((IaasContext)obj).getName()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append(this.name).toHashCode();
    }

    public int getScaleDownOrder() {
        return this.scaleDownOrder;
    }

    public void setScaleDownOrder(int scaleDownOrder) {
        this.scaleDownOrder = scaleDownOrder;
    }

    public int getScaleUpOrder() {
        return this.scaleUpOrder;
    }

    public void setScaleUpOrder(int scaleUpOrder) {
        this.scaleUpOrder = scaleUpOrder;
    }

    public void setDomainToTemplateMap(Map<String, Template> map) {
        this.domainToTemplateMap = map;
    }

    public Map<String, Template> getDomainToTemplateMap() {
        return this.domainToTemplateMap;
    }
}

