/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.javax.annotation.Nullable;

public class RunningInstance
implements Comparable<RunningInstance> {
    protected final String region;
    protected final Set<String> groupIds;
    protected final String amiLaunchIndex;
    @Nullable
    protected final String dnsName;
    protected final String imageId;
    protected final String instanceId;
    protected final InstanceState instanceState;
    protected final String rawState;
    protected final String instanceType;
    @Nullable
    protected final String ipAddress;
    @Nullable
    protected final String kernelId;
    @Nullable
    protected final String keyName;
    protected final Date launchTime;
    protected final String availabilityZone;
    protected final String virtualizationType;
    @Nullable
    protected final String platform;
    @Nullable
    protected final String privateDnsName;
    @Nullable
    protected final String privateIpAddress;
    @Nullable
    protected final String ramdiskId;
    @Nullable
    protected final String reason;
    protected final RootDeviceType rootDeviceType;
    @Nullable
    protected final String rootDeviceName;
    protected final Map<String, BlockDevice> ebsBlockDevices;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int compareTo(RunningInstance o) {
        return this == o ? 0 : this.getId().compareTo(o.getId());
    }

    protected RunningInstance(String region, Iterable<String> groupIds, @Nullable String amiLaunchIndex, @Nullable String dnsName, String imageId, String instanceId, InstanceState instanceState, String rawState, String instanceType, @Nullable String ipAddress, @Nullable String kernelId, @Nullable String keyName, Date launchTime, String availabilityZone, String virtualizationType, @Nullable String platform, @Nullable String privateDnsName, @Nullable String privateIpAddress, @Nullable String ramdiskId, @Nullable String reason, RootDeviceType rootDeviceType, @Nullable String rootDeviceName, Map<String, BlockDevice> ebsBlockDevices) {
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
        this.amiLaunchIndex = amiLaunchIndex;
        this.dnsName = dnsName;
        this.imageId = imageId;
        this.instanceId = (String)Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId");
        this.instanceState = (InstanceState)((Object)Preconditions.checkNotNull((Object)((Object)instanceState), (String)"instanceState for %s/%s", (Object[])new Object[]{region, instanceId}));
        this.rawState = (String)Preconditions.checkNotNull((Object)rawState, (String)"rawState for %s/%s", (Object[])new Object[]{region, instanceId});
        this.instanceType = (String)Preconditions.checkNotNull((Object)instanceType, (String)"instanceType for %s/%s", (Object[])new Object[]{region, instanceId});
        this.ipAddress = ipAddress;
        this.kernelId = kernelId;
        this.keyName = keyName;
        this.launchTime = launchTime;
        this.availabilityZone = availabilityZone;
        this.virtualizationType = virtualizationType;
        this.platform = platform;
        this.privateDnsName = privateDnsName;
        this.privateIpAddress = privateIpAddress;
        this.ramdiskId = ramdiskId;
        this.reason = reason;
        this.rootDeviceType = (RootDeviceType)((Object)Preconditions.checkNotNull((Object)((Object)rootDeviceType), (String)"rootDeviceType for %s/%s", (Object[])new Object[]{region, instanceId}));
        this.rootDeviceName = rootDeviceName;
        this.ebsBlockDevices = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(ebsBlockDevices, (String)"ebsBlockDevices for %s/%s", (Object[])new Object[]{region, instanceId})));
        this.groupIds = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(groupIds, (String)"groupIds for %s/%s", (Object[])new Object[]{region, instanceId})));
    }

    public String getRegion() {
        return this.region;
    }

    public String getAmiLaunchIndex() {
        return this.amiLaunchIndex;
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getId() {
        return this.instanceId;
    }

    public InstanceState getInstanceState() {
        return this.instanceState;
    }

    public String getRawState() {
        return this.rawState;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public Date getLaunchTime() {
        return this.launchTime;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String getVirtualizationType() {
        return this.virtualizationType;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getPrivateDnsName() {
        return this.privateDnsName;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public String getReason() {
        return this.reason;
    }

    public RootDeviceType getRootDeviceType() {
        return this.rootDeviceType;
    }

    public String getRootDeviceName() {
        return this.rootDeviceName;
    }

    public Map<String, BlockDevice> getEbsBlockDevices() {
        return this.ebsBlockDevices;
    }

    public Set<String> getGroupIds() {
        return this.groupIds;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.amiLaunchIndex == null ? 0 : this.amiLaunchIndex.hashCode());
        result = 31 * result + (this.availabilityZone == null ? 0 : this.availabilityZone.hashCode());
        result = 31 * result + (this.dnsName == null ? 0 : this.dnsName.hashCode());
        result = 31 * result + (this.ebsBlockDevices == null ? 0 : ((Object)this.ebsBlockDevices).hashCode());
        result = 31 * result + (this.groupIds == null ? 0 : ((Object)this.groupIds).hashCode());
        result = 31 * result + (this.imageId == null ? 0 : this.imageId.hashCode());
        result = 31 * result + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        result = 31 * result + (this.instanceType == null ? 0 : this.instanceType.hashCode());
        result = 31 * result + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
        result = 31 * result + (this.kernelId == null ? 0 : this.kernelId.hashCode());
        result = 31 * result + (this.keyName == null ? 0 : this.keyName.hashCode());
        result = 31 * result + (this.launchTime == null ? 0 : this.launchTime.hashCode());
        result = 31 * result + (this.platform == null ? 0 : this.platform.hashCode());
        result = 31 * result + (this.privateDnsName == null ? 0 : this.privateDnsName.hashCode());
        result = 31 * result + (this.privateIpAddress == null ? 0 : this.privateIpAddress.hashCode());
        result = 31 * result + (this.ramdiskId == null ? 0 : this.ramdiskId.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.rootDeviceName == null ? 0 : this.rootDeviceName.hashCode());
        result = 31 * result + (this.rootDeviceType == null ? 0 : this.rootDeviceType.hashCode());
        result = 31 * result + (this.virtualizationType == null ? 0 : this.virtualizationType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RunningInstance other = (RunningInstance)obj;
        if (this.amiLaunchIndex == null ? other.amiLaunchIndex != null : !this.amiLaunchIndex.equals(other.amiLaunchIndex)) {
            return false;
        }
        if (this.availabilityZone == null ? other.availabilityZone != null : !this.availabilityZone.equals(other.availabilityZone)) {
            return false;
        }
        if (this.dnsName == null ? other.dnsName != null : !this.dnsName.equals(other.dnsName)) {
            return false;
        }
        if (this.ebsBlockDevices == null ? other.ebsBlockDevices != null : !((Object)this.ebsBlockDevices).equals(other.ebsBlockDevices)) {
            return false;
        }
        if (this.groupIds == null ? other.groupIds != null : !((Object)this.groupIds).equals(other.groupIds)) {
            return false;
        }
        if (this.imageId == null ? other.imageId != null : !this.imageId.equals(other.imageId)) {
            return false;
        }
        if (this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId)) {
            return false;
        }
        if (this.instanceType == null ? other.instanceType != null : !this.instanceType.equals(other.instanceType)) {
            return false;
        }
        if (this.ipAddress == null ? other.ipAddress != null : !this.ipAddress.equals(other.ipAddress)) {
            return false;
        }
        if (this.kernelId == null ? other.kernelId != null : !this.kernelId.equals(other.kernelId)) {
            return false;
        }
        if (this.keyName == null ? other.keyName != null : !this.keyName.equals(other.keyName)) {
            return false;
        }
        if (this.launchTime == null ? other.launchTime != null : !this.launchTime.equals(other.launchTime)) {
            return false;
        }
        if (this.platform == null ? other.platform != null : !this.platform.equals(other.platform)) {
            return false;
        }
        if (this.privateDnsName == null ? other.privateDnsName != null : !this.privateDnsName.equals(other.privateDnsName)) {
            return false;
        }
        if (this.privateIpAddress == null ? other.privateIpAddress != null : !this.privateIpAddress.equals(other.privateIpAddress)) {
            return false;
        }
        if (this.ramdiskId == null ? other.ramdiskId != null : !this.ramdiskId.equals(other.ramdiskId)) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        if (this.rootDeviceName == null ? other.rootDeviceName != null : !this.rootDeviceName.equals(other.rootDeviceName)) {
            return false;
        }
        if (this.rootDeviceType == null ? other.rootDeviceType != null : !this.rootDeviceType.equals((Object)other.rootDeviceType)) {
            return false;
        }
        return !(this.virtualizationType == null ? other.virtualizationType != null : !this.virtualizationType.equals(other.virtualizationType));
    }

    public String toString() {
        return "[region=" + this.region + ", availabilityZone=" + this.availabilityZone + ", instanceId=" + this.instanceId + ", instanceState=" + this.rawState + ", instanceType=" + this.instanceType + ", virtualizationType=" + this.virtualizationType + ", imageId=" + this.imageId + ", ipAddress=" + this.ipAddress + ", dnsName=" + this.dnsName + ", privateIpAddress=" + this.privateIpAddress + ", privateDnsName=" + this.privateDnsName + ", keyName=" + this.keyName + ", groupIds=" + this.groupIds + ", platform=" + this.platform + ", launchTime=" + this.launchTime + ", rootDeviceName=" + this.rootDeviceName + ", rootDeviceType=" + (Object)((Object)this.rootDeviceType) + ", ebsBlockDevices=" + this.ebsBlockDevices + "]";
    }

    public static class Builder {
        protected String region;
        protected Set<String> groupIds = Sets.newLinkedHashSet();
        protected String amiLaunchIndex;
        protected String dnsName;
        protected String imageId;
        protected String instanceId;
        protected InstanceState instanceState;
        protected String rawState;
        protected String instanceType;
        protected String ipAddress;
        protected String kernelId;
        protected String keyName;
        protected Date launchTime;
        protected String availabilityZone;
        protected String virtualizationType = "paravirtual";
        protected String platform;
        protected String privateDnsName;
        protected String privateIpAddress;
        protected String ramdiskId;
        protected String reason;
        protected RootDeviceType rootDeviceType = RootDeviceType.INSTANCE_STORE;
        protected String rootDeviceName;
        protected Map<String, BlockDevice> ebsBlockDevices = Maps.newLinkedHashMap();

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder groupIds(Iterable<String> groupIds) {
            this.groupIds = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(groupIds, (Object)"groupIds")));
            return this;
        }

        public Builder groupId(String groupId) {
            if (groupId != null) {
                this.groupIds.add(groupId);
            }
            return this;
        }

        public Builder amiLaunchIndex(String amiLaunchIndex) {
            this.amiLaunchIndex = amiLaunchIndex;
            return this;
        }

        public Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder instanceState(InstanceState instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        public Builder rawState(String rawState) {
            this.rawState = rawState;
            return this;
        }

        public Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public Builder launchTime(Date launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        public Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder rootDeviceType(RootDeviceType rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        public Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public Builder devices(Map<String, BlockDevice> ebsBlockDevices) {
            this.ebsBlockDevices = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(ebsBlockDevices, (Object)"ebsBlockDevices")));
            return this;
        }

        public Builder device(String key, BlockDevice value) {
            if (key != null && value != null) {
                this.ebsBlockDevices.put(key, value);
            }
            return this;
        }

        public RunningInstance build() {
            return new RunningInstance(this.region, this.groupIds, this.amiLaunchIndex, this.dnsName, this.imageId, this.instanceId, this.instanceState, this.rawState, this.instanceType, this.ipAddress, this.kernelId, this.keyName, this.launchTime, this.availabilityZone, this.virtualizationType, this.platform, this.privateDnsName, this.privateIpAddress, this.ramdiskId, this.reason, this.rootDeviceType, this.rootDeviceName, this.ebsBlockDevices);
        }

        public String getDnsName() {
            return this.dnsName;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String getPrivateDnsName() {
            return this.privateDnsName;
        }

        public String getPrivateIpAddress() {
            return this.privateIpAddress;
        }
    }
}

