/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import java.util.Date;

public class PasswordData {
    private String requestId;
    private String instanceId;
    private Date timestamp;
    private String passwordData;

    public static Builder builder() {
        return new Builder();
    }

    public PasswordData(String requestId, String instanceId, Date timestamp, String passwordData) {
        this.requestId = requestId;
        this.instanceId = instanceId;
        this.timestamp = timestamp;
        this.passwordData = passwordData;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getPasswordData() {
        return this.passwordData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PasswordData that = (PasswordData)o;
        if (this.instanceId != null ? !this.instanceId.equals(that.instanceId) : that.instanceId != null) {
            return false;
        }
        if (this.passwordData != null ? !this.passwordData.equals(that.passwordData) : that.passwordData != null) {
            return false;
        }
        if (this.requestId != null ? !this.requestId.equals(that.requestId) : that.requestId != null) {
            return false;
        }
        return !(this.timestamp != null ? !this.timestamp.equals(that.timestamp) : that.timestamp != null);
    }

    public int hashCode() {
        int result = this.requestId != null ? this.requestId.hashCode() : 0;
        result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        result = 31 * result + (this.passwordData != null ? this.passwordData.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PasswordData{requestId='" + this.requestId + '\'' + ", instanceId='" + this.instanceId + '\'' + ", timestamp=" + this.timestamp + ", passwordData='" + this.passwordData + '\'' + '}';
    }

    public static class Builder {
        private String requestId;
        private String instanceId;
        private Date timestamp;
        private String passwordData;

        private Builder() {
        }

        public Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder passwordData(String passwordData) {
            this.passwordData = passwordData;
            return this;
        }

        public PasswordData build() {
            return new PasswordData(this.requestId, this.instanceId, this.timestamp, this.passwordData);
        }
    }
}

