/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.callables.BlockUntilInitScriptStatusIsZeroThenReturnOutput;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.callables.RunScriptOnNodeAsInitScriptUsingSsh;
import org.jclouds.compute.callables.RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete;
import org.jclouds.compute.callables.RunScriptOnNodeUsingSsh;
import org.jclouds.compute.config.ComputeServiceTimeoutsModule;
import org.jclouds.compute.config.GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull;
import org.jclouds.compute.config.PersistNodeCredentialsModule;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.functions.CreateSshClientOncePortIsListeningOnNode;
import org.jclouds.compute.functions.DefaultCredentialsFromImageOrOverridingCredentials;
import org.jclouds.compute.functions.TemplateOptionsToStatement;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.json.Json;
import org.jclouds.location.Provider;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.ssh.SshClient;
import org.jclouds.util.Suppliers2;

public abstract class BaseComputeServiceContextModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new ComputeServiceTimeoutsModule());
        this.bind((TypeLiteral)new TypeLiteral<Function<NodeMetadata, SshClient>>(){}).to(CreateSshClientOncePortIsListeningOnNode.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<TemplateOptions, Statement>>(){}).to(TemplateOptionsToStatement.class);
        this.bind(LoginCredentials.class).annotatedWith((Annotation)Names.named((String)"image")).toProvider(GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Template, LoginCredentials>>(){}).to(DefaultCredentialsFromImageOrOverridingCredentials.class);
        this.install(new FactoryModuleBuilder().implement(RunScriptOnNodeUsingSsh.class, (Annotation)Names.named((String)"direct"), RunScriptOnNodeUsingSsh.class).implement(RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete.class, (Annotation)Names.named((String)"blocking"), RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete.class).implement(RunScriptOnNodeAsInitScriptUsingSsh.class, (Annotation)Names.named((String)"nonblocking"), RunScriptOnNodeAsInitScriptUsingSsh.class).build(RunScriptOnNodeFactoryImpl.Factory.class));
        this.install((Module)new PersistNodeCredentialsModule());
        this.bind(RunScriptOnNode.Factory.class).to(RunScriptOnNodeFactoryImpl.class);
        this.install(new FactoryModuleBuilder().implement((TypeLiteral)new TypeLiteral<Callable<Void>>(){}, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.class).implement((TypeLiteral)new TypeLiteral<Function<AtomicReference<NodeMetadata>, Void>>(){}, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.class).build(CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory.class));
        this.install(new FactoryModuleBuilder().implement((TypeLiteral)new TypeLiteral<Callable<RunScriptOnNode>>(){}, InitializeRunScriptOnNodeOrPlaceInBadMap.class).build(InitializeRunScriptOnNodeOrPlaceInBadMap.Factory.class));
        this.install(new FactoryModuleBuilder().build(BlockUntilInitScriptStatusIsZeroThenReturnOutput.Factory.class));
    }

    @Provides
    @Singleton
    public Map<OsFamily, Map<String, String>> provideOsVersionMap(ComputeServiceConstants.ReferenceData data, Json json) {
        return (Map)json.fromJson(data.osVersionMapJson, new TypeLiteral<Map<OsFamily, Map<String, String>>>(){}.getType());
    }

    @Provides
    @Named(value="DEFAULT")
    protected TemplateBuilder provideTemplateOptionallyFromProperties(Injector injector, TemplateBuilder template, @Provider String provider, ValueOfConfigurationKeyOrNull config) {
        String templateString = config.apply(provider + ".template");
        if (templateString == null) {
            templateString = config.apply("jclouds.template");
        }
        if (templateString != null) {
            template.from(templateString);
        } else {
            template.osFamily(OsFamily.UBUNTU).osVersionMatches("1[012].[01][04]").os64Bit(true);
        }
        String imageId = config.apply(provider + ".image-id");
        if (imageId == null) {
            imageId = config.apply("jclouds.image-id");
        }
        if (imageId != null) {
            template.imageId(imageId);
        }
        return template;
    }

    @Provides
    @Singleton
    protected Map<OsFamily, LoginCredentials> osFamilyToCredentials(Injector injector) {
        return ImmutableMap.of((Object)((Object)OsFamily.WINDOWS), (Object)LoginCredentials.builder().user("Administrator").build());
    }

    @Provides
    @Named(value="DEFAULT")
    protected TemplateOptions provideTemplateOptions(Injector injector, TemplateOptions options) {
        return options;
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, ? extends Image>> provideImageMap(@Memoized Supplier<Set<? extends Image>> images) {
        return Suppliers2.compose((Function)new Function<Set<? extends Image>, Map<String, ? extends Image>>(){

            public Map<String, ? extends Image> apply(Set<? extends Image> from) {
                return Maps.uniqueIndex(from, (Function)new Function<Image, String>(){

                    public String apply(Image from) {
                        return from.getId();
                    }
                });
            }
        }, images);
    }

    @Provides
    @Singleton
    @Memoized
    protected Supplier<Set<? extends Image>> supplyImageCache(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, Supplier<Set<? extends Image>> imageSupplier, Injector injector) {
        if (this.shouldEagerlyParseImages(injector)) {
            return this.supplyImageCache(authException, seconds, imageSupplier);
        }
        return this.supplyNonParsingImageCache(authException, seconds, imageSupplier, injector);
    }

    protected boolean shouldEagerlyParseImages(Injector injector) {
        return true;
    }

    protected Supplier<Set<? extends Image>> supplyImageCache(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, Supplier<Set<? extends Image>> imageSupplier) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, imageSupplier, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }

    protected Supplier<Set<? extends Image>> supplyNonParsingImageCache(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, Supplier<Set<? extends Image>> imageSupplier, Injector injector) {
        return this.supplyImageCache(authException, seconds, imageSupplier);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, ? extends Hardware>> provideSizeMap(@Memoized Supplier<Set<? extends Hardware>> sizes) {
        return Suppliers2.compose((Function)new Function<Set<? extends Hardware>, Map<String, ? extends Hardware>>(){

            public Map<String, ? extends Hardware> apply(Set<? extends Hardware> from) {
                return Maps.uniqueIndex(from, (Function)new Function<Hardware, String>(){

                    public String apply(Hardware from) {
                        return from.getId();
                    }
                });
            }
        }, sizes);
    }

    @Provides
    @Singleton
    @Memoized
    protected Supplier<Set<? extends Hardware>> supplySizeCache(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, Supplier<Set<? extends Hardware>> hardwareSupplier) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, hardwareSupplier, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    protected Function<ComputeMetadata, String> indexer() {
        return new Function<ComputeMetadata, String>(){

            public String apply(ComputeMetadata from) {
                return from.getProviderId();
            }
        };
    }

    @Provides
    @Singleton
    protected Optional<ImageExtension> provideImageExtension(Injector i) {
        return Optional.absent();
    }

    @Singleton
    static class RunScriptOnNodeFactoryImpl
    implements RunScriptOnNode.Factory {
        private final Factory factory;

        @Inject
        RunScriptOnNodeFactoryImpl(Factory factory) {
            this.factory = (Factory)Preconditions.checkNotNull((Object)factory, (Object)"factory");
        }

        @Override
        public RunScriptOnNode create(NodeMetadata node, Statement runScript, RunScriptOptions options) {
            Preconditions.checkNotNull((Object)node, (Object)"node");
            Preconditions.checkNotNull((Object)runScript, (Object)"runScript");
            Preconditions.checkNotNull((Object)options, (Object)"options");
            return !options.shouldWrapInInitScript() ? this.factory.exec(node, runScript, options) : (options.shouldBlockOnComplete() ? this.factory.backgroundAndBlockOnComplete(node, runScript, options) : this.factory.background(node, runScript, options));
        }

        public BlockUntilInitScriptStatusIsZeroThenReturnOutput submit(NodeMetadata node, Statement script, RunScriptOptions options) {
            Preconditions.checkNotNull((Object)node, (Object)"node");
            Preconditions.checkNotNull((Object)script, (Object)"script");
            Preconditions.checkNotNull((Object)options, (Object)"options");
            options.shouldWrapInInitScript();
            return this.factory.backgroundAndBlockOnComplete(node, script, options).init().future();
        }

        static interface Factory {
            @Named(value="direct")
            public RunScriptOnNodeUsingSsh exec(NodeMetadata var1, Statement var2, RunScriptOptions var3);

            @Named(value="blocking")
            public RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete backgroundAndBlockOnComplete(NodeMetadata var1, Statement var2, RunScriptOptions var3);

            @Named(value="nonblocking")
            public RunScriptOnNodeAsInitScriptUsingSsh background(NodeMetadata var1, Statement var2, RunScriptOptions var3);
        }
    }
}

