/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.common.xml.XmlException;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.templates.NullTemplateLibrary;
import org.apache.shindig.gadgets.templates.TemplateLibrary;
import org.apache.shindig.gadgets.templates.XmlTemplateLibrary;

@Singleton
public class ContainerTagLibraryFactory {
    private static final Logger logger = Logger.getLogger(ContainerTagLibraryFactory.class.getName());
    private final ContainerConfig config;
    private final ConcurrentMap<String, TemplateLibrary> osmlLibraryCache = new MapMaker().makeComputingMap((Function)new Function<String, TemplateLibrary>(){

        public TemplateLibrary apply(String resourceName) {
            return ContainerTagLibraryFactory.loadTrustedLibrary(resourceName);
        }
    });

    @Inject
    public ContainerTagLibraryFactory(ContainerConfig config) {
        this.config = config;
    }

    public TemplateLibrary getLibrary(String container) {
        return this.getOsmlLibrary(container);
    }

    private TemplateLibrary getOsmlLibrary(String container) {
        String library = this.config.getString(container, "${Cur['gadgets.features'].osml.library}");
        if (StringUtils.isEmpty((String)library)) {
            return NullTemplateLibrary.INSTANCE;
        }
        return (TemplateLibrary)this.osmlLibraryCache.get(library);
    }

    private static TemplateLibrary loadTrustedLibrary(String resource) {
        try {
            String content = ResourceLoader.getContent(resource);
            return new XmlTemplateLibrary(Uri.parse("#OSML"), XmlUtil.parse(content), content, true);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, null, ioe);
        }
        catch (XmlException xe) {
            logger.log(Level.WARNING, null, xe);
        }
        catch (GadgetException tpe) {
            logger.log(Level.WARNING, null, tpe);
        }
        return NullTemplateLibrary.INSTANCE;
    }
}

