/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationManifest {
    public static final String NAMESPACE = "http://ns.opensocial.org/2008/application";
    private final Map<String, String> versions;
    private final Map<String, Uri> gadgets;
    private final Uri uri;

    public ApplicationManifest(Uri uri, Element xml) throws SpecParserException {
        ImmutableMap.Builder versions = ImmutableMap.builder();
        ImmutableMap.Builder gadgets = ImmutableMap.builder();
        NodeList nodes = xml.getElementsByTagName("gadget");
        int j = nodes.getLength();
        for (int i = 0; i < j; ++i) {
            Element gadget = (Element)nodes.item(i);
            String version = ApplicationManifest.getVersionString(gadget);
            Uri spec = ApplicationManifest.getSpecUri(uri, gadget);
            gadgets.put((Object)version, (Object)spec);
            for (String label : ApplicationManifest.getLabels(gadget)) {
                versions.put((Object)label, (Object)version);
            }
        }
        this.uri = uri;
        this.versions = versions.build();
        this.gadgets = gadgets.build();
    }

    private static Uri getSpecUri(Uri baseUri, Element gadget) throws SpecParserException {
        NodeList specs = gadget.getElementsByTagName("spec");
        if (specs.getLength() > 1) {
            throw new SpecParserException("Only one spec per gadget block may be specified.");
        }
        if (specs.getLength() == 0) {
            throw new SpecParserException("No spec specified.");
        }
        try {
            String relative = specs.item(0).getTextContent();
            Uri specUri = baseUri.resolve(Uri.parse(relative));
            if (specUri.equals(baseUri)) {
                throw new SpecParserException("Manifest is self-referencing.");
            }
            return specUri;
        }
        catch (IllegalArgumentException e) {
            throw new SpecParserException("Invalid spec URI.");
        }
    }

    private static String getVersionString(Element gadget) throws SpecParserException {
        NodeList versions = gadget.getElementsByTagName("version");
        if (versions.getLength() > 1) {
            throw new SpecParserException("Only one version per gadget block may be specified.");
        }
        if (versions.getLength() == 0) {
            throw new SpecParserException("No version specified.");
        }
        return versions.item(0).getTextContent();
    }

    private static List<String> getLabels(Element gadget) {
        NodeList labels = gadget.getElementsByTagName("label");
        ArrayList<String> list = new ArrayList<String>(labels.getLength());
        int j = labels.getLength();
        for (int i = 0; i < j; ++i) {
            list.add(labels.item(i).getTextContent());
        }
        return list;
    }

    public Uri getUri() {
        return this.uri;
    }

    public Uri getGadget(String version) {
        return this.gadgets.get(version);
    }

    public String getVersion(String label) {
        return this.versions.get(label);
    }
}

