/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.UserPrefs;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonRpcGadgetContext
extends GadgetContext {
    private final JSONObject context;
    private final JSONObject gadget;
    private final String container;
    private final Boolean debug;
    private final Boolean ignoreCache;
    private final Locale locale;
    private final Integer moduleId;
    private final RenderingContext renderingContext;
    private final Uri url;
    private final UserPrefs userPrefs;
    private final String view;
    private final String cookies;
    private final String hostDomain;

    public JsonRpcGadgetContext(JSONObject context, JSONObject gadget) throws JSONException {
        this.context = context;
        this.gadget = gadget;
        this.url = JsonRpcGadgetContext.getUrl(gadget);
        this.moduleId = JsonRpcGadgetContext.getModuleId(gadget);
        this.userPrefs = JsonRpcGadgetContext.getUserPrefs(gadget);
        this.locale = JsonRpcGadgetContext.getLocale(context);
        this.view = context.optString("view");
        this.ignoreCache = context.optBoolean("ignoreCache");
        this.container = context.optString("container");
        this.debug = context.optBoolean("debug");
        this.renderingContext = RenderingContext.METADATA;
        this.hostDomain = context.optString("hostDomain");
        this.cookies = JsonRpcGadgetContext.getCookies(context, gadget);
    }

    public String getParameter(String name) {
        if (this.gadget.has(name)) {
            return this.gadget.optString(name);
        }
        return this.context.optString(name, null);
    }

    public String getContainer() {
        if (this.container == null) {
            return super.getContainer();
        }
        return this.container;
    }

    public boolean getDebug() {
        if (this.debug == null) {
            return super.getDebug();
        }
        return this.debug;
    }

    public boolean getIgnoreCache() {
        if (this.ignoreCache == null) {
            return super.getIgnoreCache();
        }
        return this.ignoreCache;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return super.getLocale();
        }
        return this.locale;
    }

    public int getModuleId() {
        if (this.moduleId == null) {
            return super.getModuleId();
        }
        return this.moduleId;
    }

    public RenderingContext getRenderingContext() {
        if (this.renderingContext == null) {
            return super.getRenderingContext();
        }
        return this.renderingContext;
    }

    public Uri getUrl() {
        if (this.url == null) {
            return super.getUrl();
        }
        return this.url;
    }

    public UserPrefs getUserPrefs() {
        if (this.userPrefs == null) {
            return super.getUserPrefs();
        }
        return this.userPrefs;
    }

    public String getView() {
        if (this.view == null) {
            return super.getView();
        }
        return this.view;
    }

    private static Locale getLocale(JSONObject obj) {
        String language = obj.optString("language");
        String country = obj.optString("country");
        if (language == null || country == null) {
            return null;
        }
        return new Locale(language, country);
    }

    private static Integer getModuleId(JSONObject json) throws JSONException {
        if (json.has("moduleId")) {
            return json.getInt("moduleId");
        }
        return null;
    }

    private static Uri getUrl(JSONObject json) throws JSONException {
        try {
            String url = json.getString("url");
            return Uri.parse(url);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static UserPrefs getUserPrefs(JSONObject json) throws JSONException {
        JSONObject prefs = json.optJSONObject("prefs");
        if (prefs == null) {
            return null;
        }
        HashMap p = Maps.newHashMap();
        Iterator i = prefs.keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            p.put(key, prefs.getString(key));
        }
        return new UserPrefs(p);
    }

    public String getCookies() {
        if (this.cookies == null) {
            return super.getCookies();
        }
        return this.cookies;
    }

    public String getHostDomain() {
        return this.hostDomain;
    }

    private static String getCookies(JSONObject context, JSONObject gadget) throws JSONException {
        String hostDomain;
        String cookies = context.optString("cookies");
        String url = gadget.getString("url");
        if (url.contains(hostDomain = context.optString("hostDomain"))) {
            return cookies;
        }
        return "";
    }
}

