/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RequestRewriter;
import org.apache.shindig.gadgets.rewrite.RequestRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewritingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRequestRewriterRegistry
implements RequestRewriterRegistry {
    protected final List<RequestRewriter> rewriters;
    protected final GadgetHtmlParser htmlParser;

    @Inject
    public DefaultRequestRewriterRegistry(List<RequestRewriter> rewriters, GadgetHtmlParser htmlParser) {
        if (rewriters == null) {
            rewriters = Collections.emptyList();
        }
        this.rewriters = Lists.newLinkedList(rewriters);
        this.htmlParser = htmlParser;
    }

    @Override
    public HttpResponse rewriteHttpResponse(HttpRequest req, HttpResponse resp) throws RewritingException {
        MutableContent mc = new MutableContent(this.htmlParser, resp);
        boolean wasRewritten = false;
        for (RequestRewriter rewriter : this.rewriters) {
            wasRewritten |= rewriter.rewrite(req, resp, mc);
        }
        if (wasRewritten) {
            return new HttpResponseBuilder(resp).setResponseString(mc.getContent()).create();
        }
        return resp;
    }
}

