/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.MessageBundleFactory;
import org.apache.shindig.gadgets.UnsupportedFeatureException;
import org.apache.shindig.gadgets.UrlGenerator;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.preload.PreloadException;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.render.RpcServiceLookup;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.MessageBundle;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderingGadgetRewriter
implements GadgetRewriter {
    private static final Logger LOG = Logger.getLogger(RenderingGadgetRewriter.class.getName());
    private static final int INLINE_JS_BUFFER = 50;
    protected static final String DEFAULT_CSS = "body,td,div,span,p{font-family:arial,sans-serif;}a {color:#0000cc;}a:visited {color:#551a8b;}a:active {color:#ff0000;}body{margin: 0px;padding: 0px;background-color:white;}";
    static final String IS_GADGET_BEACON = "window['__isgadget']=true;";
    static final String INSERT_BASE_ELEMENT_KEY = "gadgets.insertBaseElement";
    static final String FEATURES_KEY = "gadgets.features";
    protected final MessageBundleFactory messageBundleFactory;
    protected final ContainerConfig containerConfig;
    protected final FeatureRegistry featureRegistry;
    protected final UrlGenerator urlGenerator;
    protected final RpcServiceLookup rpcServiceLookup;
    protected Set<String> defaultExternLibs = ImmutableSet.of();
    protected Boolean externalizeFeatures = false;

    @Inject
    public RenderingGadgetRewriter(MessageBundleFactory messageBundleFactory, ContainerConfig containerConfig, FeatureRegistry featureRegistry, UrlGenerator urlGenerator, RpcServiceLookup rpcServiceLookup) {
        this.messageBundleFactory = messageBundleFactory;
        this.containerConfig = containerConfig;
        this.featureRegistry = featureRegistry;
        this.urlGenerator = urlGenerator;
        this.rpcServiceLookup = rpcServiceLookup;
    }

    @Inject
    public void setDefaultForcedLibs(@Named(value="shindig.gadget-rewrite.default-forced-libs") String forcedLibs) {
        if (StringUtils.isNotBlank((String)forcedLibs)) {
            this.defaultExternLibs = ImmutableSortedSet.of((Comparable[])StringUtils.split((String)forcedLibs, (char)':'));
        }
    }

    @Inject(optional=true)
    public void setExternalizeFeatureLibs(@Named(value="shindig.gadget-rewrite.externalize-feature-libs") Boolean externalizeFeatures) {
        this.externalizeFeatures = externalizeFeatures;
    }

    @Override
    public void rewrite(Gadget gadget, MutableContent mutableContent) throws RewritingException {
        if (gadget.sanitizeOutput()) {
            return;
        }
        try {
            Document document = mutableContent.getDocument();
            Element head = (Element)DomUtil.getFirstNamedChildNode(document.getDocumentElement(), "head");
            NodeList children = head.getChildNodes();
            ArrayList existingHeadContent = Lists.newArrayListWithExpectedSize((int)children.getLength());
            for (int i = 0; i < children.getLength(); ++i) {
                existingHeadContent.add(children.item(i));
            }
            for (Node n : existingHeadContent) {
                head.removeChild(n);
            }
            if (document.getDoctype() == null) {
                Element defaultStyle = document.createElement("style");
                defaultStyle.setAttribute("type", "text/css");
                head.appendChild(defaultStyle);
                defaultStyle.appendChild(defaultStyle.getOwnerDocument().createTextNode(DEFAULT_CSS));
            }
            this.injectBaseTag(gadget, head);
            this.injectGadgetBeacon(gadget, head);
            this.injectFeatureLibraries(gadget, head);
            Element mainScriptTag = document.createElement("script");
            GadgetContext context = gadget.getContext();
            MessageBundle bundle = this.messageBundleFactory.getBundle(gadget.getSpec(), context.getLocale(), context.getIgnoreCache());
            this.injectMessageBundles(bundle, mainScriptTag);
            this.injectDefaultPrefs(gadget, mainScriptTag);
            this.injectPreloads(gadget, mainScriptTag);
            head.appendChild(mainScriptTag);
            Element body = (Element)DomUtil.getFirstNamedChildNode(document.getDocumentElement(), "body");
            body.setAttribute("dir", bundle.getLanguageDirection());
            for (Node node : existingHeadContent) {
                head.appendChild(node);
            }
            this.injectOnLoadHandlers(body);
            mutableContent.documentChanged();
        }
        catch (GadgetException e) {
            throw new RewritingException(e.getLocalizedMessage(), e, e.getHttpStatusCode());
        }
    }

    protected void injectBaseTag(Gadget gadget, Node headTag) {
        GadgetContext context = gadget.getContext();
        if (this.containerConfig.getBool(context.getContainer(), INSERT_BASE_ELEMENT_KEY)) {
            Uri base = gadget.getSpec().getUrl();
            View view = gadget.getCurrentView();
            if (view != null && view.getHref() != null) {
                base = view.getHref();
            }
            Element baseTag = headTag.getOwnerDocument().createElement("base");
            baseTag.setAttribute("href", base.toString());
            headTag.insertBefore(baseTag, headTag.getFirstChild());
        }
    }

    protected void injectOnLoadHandlers(Node bodyTag) {
        Element onloadScript = bodyTag.getOwnerDocument().createElement("script");
        bodyTag.appendChild(onloadScript);
        onloadScript.appendChild(bodyTag.getOwnerDocument().createTextNode("gadgets.util.runOnLoadHandlers();"));
    }

    protected void injectGadgetBeacon(Gadget gadget, Node headTag) throws GadgetException {
        Element beaconNode = headTag.getOwnerDocument().createElement("script");
        beaconNode.setTextContent(IS_GADGET_BEACON);
        headTag.appendChild(beaconNode);
    }

    protected void injectFeatureLibraries(Gadget gadget, Node headTag) throws GadgetException {
        GadgetContext context = gadget.getContext();
        TreeSet externForcedLibs = this.defaultExternLibs;
        String externParam = context.getParameter("libs");
        if (StringUtils.isNotBlank((String)externParam)) {
            externForcedLibs = Sets.newTreeSet(Arrays.asList(StringUtils.split((String)externParam, (char)':')));
        }
        if (!externForcedLibs.isEmpty()) {
            String jsUrl = this.urlGenerator.getBundledJsUrl(externForcedLibs, context);
            Element libsTag = headTag.getOwnerDocument().createElement("script");
            libsTag.setAttribute("src", jsUrl);
            headTag.appendChild(libsTag);
        }
        LinkedList unsupported = Lists.newLinkedList();
        List<FeatureResource> externForcedResources = this.featureRegistry.getFeatureResources(context, externForcedLibs, unsupported);
        if (!unsupported.isEmpty()) {
            LOG.info("Unknown feature(s) in extern &libs=: " + ((Object)unsupported).toString());
            unsupported.clear();
        }
        Map<String, Feature> featureMap = gadget.getSpec().getModulePrefs().getFeatures();
        ArrayList gadgetFeatureKeys = Lists.newArrayList(gadget.getDirectFeatureDeps());
        List<FeatureResource> gadgetResources = this.featureRegistry.getFeatureResources(context, gadgetFeatureKeys, unsupported);
        if (!unsupported.isEmpty()) {
            LinkedList requiredUnsupported = Lists.newLinkedList();
            for (String notThere : unsupported) {
                if (featureMap.containsKey(notThere) && !featureMap.get(notThere).getRequired()) continue;
                requiredUnsupported.add(notThere);
            }
            if (!requiredUnsupported.isEmpty()) {
                throw new UnsupportedFeatureException(((Object)requiredUnsupported).toString());
            }
        }
        ArrayList inlineResources = Lists.newArrayList();
        ArrayList allRequested = Lists.newArrayList((Iterable)gadgetFeatureKeys);
        if (this.externalizeFeatures.booleanValue()) {
            TreeSet externGadgetLibs = Sets.newTreeSet(this.featureRegistry.getFeatures(gadgetFeatureKeys));
            externGadgetLibs.removeAll(externForcedLibs);
            if (!externGadgetLibs.isEmpty()) {
                String jsUrl = this.urlGenerator.getBundledJsUrl(externGadgetLibs, context);
                Element libsTag = headTag.getOwnerDocument().createElement("script");
                libsTag.setAttribute("src", jsUrl);
                headTag.appendChild(libsTag);
            }
        } else {
            inlineResources.addAll(gadgetResources);
        }
        if (!externForcedLibs.isEmpty()) {
            allRequested.addAll(externForcedLibs);
            inlineResources.removeAll(externForcedResources);
        }
        int size = 0;
        for (FeatureResource resource : inlineResources) {
            if (resource.isExternal()) continue;
            if (context.getDebug()) {
                size += resource.getDebugContent().length();
                continue;
            }
            size += resource.getContent().length();
        }
        String libraryConfig = this.getLibraryConfig(gadget, this.featureRegistry.getFeatures(allRequested));
        StringBuilder inlineJs = new StringBuilder(size + libraryConfig.length() + 50);
        for (FeatureResource resource : inlineResources) {
            String theContent;
            String string = theContent = context.getDebug() ? resource.getDebugContent() : resource.getContent();
            if (resource.isExternal()) {
                if (inlineJs.length() > 0) {
                    Element inlineTag = headTag.getOwnerDocument().createElement("script");
                    headTag.appendChild(inlineTag);
                    inlineTag.appendChild(headTag.getOwnerDocument().createTextNode(inlineJs.toString()));
                    inlineJs.setLength(0);
                }
                Element referenceTag = headTag.getOwnerDocument().createElement("script");
                referenceTag.setAttribute("src", theContent);
                headTag.appendChild(referenceTag);
                continue;
            }
            inlineJs.append(theContent).append(";\n");
        }
        inlineJs.append(libraryConfig);
        if (inlineJs.length() > 0) {
            Element inlineTag = headTag.getOwnerDocument().createElement("script");
            headTag.appendChild(inlineTag);
            inlineTag.appendChild(headTag.getOwnerDocument().createTextNode(inlineJs.toString()));
        }
    }

    protected String getLibraryConfig(Gadget gadget, List<String> reqs) throws GadgetException {
        GadgetContext context = gadget.getContext();
        Map<String, Object> features = this.containerConfig.getMap(context.getContainer(), FEATURES_KEY);
        HashMap config = Maps.newHashMapWithExpectedSize((int)(features == null ? 2 : features.size() + 2));
        if (features != null) {
            for (String name : reqs) {
                Object conf = features.get(name);
                if (conf == null) continue;
                config.put(name, conf);
            }
        }
        this.addHasFeatureConfig(gadget, config);
        this.addOsapiSystemListMethodsConfig(context.getContainer(), config, context.getHost());
        this.addSecurityTokenConfig(context, config);
        return "gadgets.config.init(" + JsonSerializer.serialize(config) + ");\n";
    }

    private void addSecurityTokenConfig(GadgetContext context, Map<String, Object> config) {
        SecurityToken authToken = context.getToken();
        if (authToken != null) {
            String trustedJson;
            HashMap authConfig = Maps.newHashMapWithExpectedSize((int)2);
            String updatedToken = authToken.getUpdatedToken();
            if (updatedToken != null) {
                authConfig.put("authToken", updatedToken);
            }
            if ((trustedJson = authToken.getTrustedJson()) != null) {
                authConfig.put("trustedJson", trustedJson);
            }
            config.put("shindig.auth", authConfig);
        }
    }

    private void addHasFeatureConfig(Gadget gadget, Map<String, Object> config) {
        ModulePrefs prefs = gadget.getSpec().getModulePrefs();
        Collection<Feature> features = prefs.getFeatures().values();
        HashMap featureMap = Maps.newHashMapWithExpectedSize((int)features.size());
        for (Feature feature : features) {
            HashMap paramFeaturesInConfig = Maps.newHashMap();
            for (String paramName : feature.getParams().keySet()) {
                Collection paramValues = feature.getParams().get((Object)paramName);
                if (paramValues.size() == 1) {
                    paramFeaturesInConfig.put(paramName, paramValues.iterator().next());
                    continue;
                }
                paramFeaturesInConfig.put(paramName, paramValues);
            }
            featureMap.put(feature.getName(), paramFeaturesInConfig);
        }
        config.put("core.util", featureMap);
    }

    private void addOsapiSystemListMethodsConfig(String container, Map<String, Object> config, String host) {
        if (this.rpcServiceLookup != null) {
            Multimap<String, String> endpoints = this.rpcServiceLookup.getServicesFor(container, host);
            config.put("osapi.services", endpoints);
        }
    }

    protected void injectMessageBundles(MessageBundle bundle, Node scriptTag) throws GadgetException {
        String msgs = bundle.toJSONString();
        Text text = scriptTag.getOwnerDocument().createTextNode("gadgets.Prefs.setMessages_(");
        text.appendData(msgs);
        text.appendData(");");
        scriptTag.appendChild(text);
    }

    protected void injectDefaultPrefs(Gadget gadget, Node scriptTag) {
        List<UserPref> prefs = gadget.getSpec().getUserPrefs();
        HashMap defaultPrefs = Maps.newHashMapWithExpectedSize((int)prefs.size());
        for (UserPref up : prefs) {
            defaultPrefs.put(up.getName(), up.getDefaultValue());
        }
        Text text = scriptTag.getOwnerDocument().createTextNode("gadgets.Prefs.setDefaultPrefs_(");
        text.appendData(JsonSerializer.serialize(defaultPrefs));
        text.appendData(");");
        scriptTag.appendChild(text);
    }

    protected void injectPreloads(Gadget gadget, Node scriptTag) {
        ArrayList preload = Lists.newArrayList();
        for (PreloadedData preloaded : gadget.getPreloads()) {
            try {
                preload.addAll(preloaded.toJson());
            }
            catch (PreloadException pe) {
                LOG.log(Level.WARNING, "Unexpected error when preloading", pe);
            }
        }
        Text text = scriptTag.getOwnerDocument().createTextNode("gadgets.io.preloaded_=");
        text.appendData(JsonSerializer.serialize(preload));
        text.appendData(";");
        scriptTag.appendChild(text);
    }
}

