/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel.forwarded;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import net.schmizz.concurrent.Event;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.connection.channel.SocketStreamCopyMonitor;
import net.schmizz.sshj.connection.channel.forwarded.ConnectListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketForwardingConnectListener
implements ConnectListener {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final SocketAddress addr;

    public SocketForwardingConnectListener(SocketAddress addr) {
        this.addr = addr;
    }

    @Override
    public void gotConnect(Channel.Forwarded chan) throws IOException {
        this.log.info("New connection from {}:{}", (Object)chan.getOriginatorIP(), (Object)chan.getOriginatorPort());
        Socket sock = new Socket();
        sock.setSendBufferSize(chan.getLocalMaxPacketSize());
        sock.setReceiveBufferSize(chan.getRemoteMaxPacketSize());
        sock.connect(this.addr);
        chan.confirm();
        Event<IOException> soc2chan = new StreamCopier(sock.getInputStream(), chan.getOutputStream()).bufSize(chan.getRemoteMaxPacketSize()).spawnDaemon("soc2chan");
        Event<IOException> chan2soc = new StreamCopier(chan.getInputStream(), sock.getOutputStream()).bufSize(chan.getLocalMaxPacketSize()).spawnDaemon("chan2soc");
        SocketStreamCopyMonitor.monitor(5, TimeUnit.SECONDS, chan2soc, soc2chan, chan, sock);
    }
}

