/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.openstack.keystone.v2_0.domain.Endpoint;

public class Service
extends ForwardingSet<Endpoint>
implements Comparable<Service> {
    private final String type;
    private final String name;
    private final Set<Endpoint> endpoints;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromService(this);
    }

    @ConstructorProperties(value={"type", "name", "endpoints"})
    protected Service(String type, String name, Set<Endpoint> endpoints) {
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.endpoints = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(endpoints, (Object)"endpoints")));
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Set<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.name, this.endpoints});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Service that = (Service)Service.class.cast(obj);
        return Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.endpoints, that.endpoints);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("type", (Object)this.type).add("name", (Object)this.name).add("endpoints", this.endpoints);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Service that) {
        return ComparisonChain.start().compare((Comparable)((Object)this.type), (Comparable)((Object)that.type)).compare((Comparable)((Object)this.name), (Comparable)((Object)that.name)).result();
    }

    protected Set<Endpoint> delegate() {
        return this.endpoints;
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String type;
        protected String name;
        protected Set<Endpoint> endpoints = ImmutableSet.of();

        protected abstract T self();

        public T type(String type) {
            this.type = type;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T endpoints(Set<Endpoint> endpoints) {
            this.endpoints = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(endpoints, (Object)"endpoints")));
            return this.self();
        }

        public T endpoints(Endpoint ... in) {
            return this.endpoints((Set<Endpoint>)ImmutableSet.copyOf((Object[])in));
        }

        public Service build() {
            return new Service(this.type, this.name, this.endpoints);
        }

        public T fromService(Service in) {
            return ((Builder)((Builder)this.type(in.getType())).name(in.getName())).endpoints(in.getEndpoints());
        }
    }
}

