/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.jclouds.openstack.keystone.v2_0.domain.ApiMetadata;
import org.jclouds.openstack.keystone.v2_0.features.ServiceAsyncClient;
import org.jclouds.openstack.keystone.v2_0.features.TenantAsyncClient;
import org.jclouds.openstack.keystone.v2_0.features.TokenAsyncClient;
import org.jclouds.openstack.keystone.v2_0.features.UserAsyncClient;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

public interface KeystoneAsyncClient {
    @GET
    @SelectJson(value="version")
    @Consumes(value={"application/json"})
    @Path(value="/v{jclouds.api-version}/")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<ApiMetadata> getApiMetadata();

    @Delegate
    public ServiceAsyncClient getServiceClient();

    @Delegate
    public Optional<TokenAsyncClient> getTokenClient();

    @Delegate
    public Optional<UserAsyncClient> getUserClient();

    @Delegate
    public Optional<TenantAsyncClient> getTenantClient();
}

