/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.attachment.mgt.core.dao.impl.jpa.openjpa;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.wso2.carbon.attachment.mgt.core.dao.impl.TransactionManagerProvider;
import org.wso2.carbon.attachment.mgt.core.dao.impl.jpa.AbstractJPAVendorAdapter;
import org.wso2.carbon.attachment.mgt.core.dao.impl.jpa.DatabaseType;

public class OpenJPAVendorAdapter
extends AbstractJPAVendorAdapter {
    @Override
    public Map<String, ?> getJpaPropertyMap(TransactionManager transactionManager) {
        HashMap<String, Object> jpaProperties = new HashMap<String, Object>();
        if (this.getDataSource() != null) {
            jpaProperties.put("openjpa.ConnectionFactory", this.getDataSource());
            String dbDictionary = this.determineDbDictionary();
            if (dbDictionary != null) {
                this.log.info((Object)("[Attachment-Mgt OpenJPA] DB Dictionary: " + dbDictionary));
                jpaProperties.put("openjpa.jdbc.DBDictionary", dbDictionary);
            }
        }
        if (this.isGenerateDDL()) {
            this.log.info((Object)"[Attachment-Mgt OpenJPA] Generate DDL Enabled.");
            jpaProperties.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
        }
        if (this.isShowSQL()) {
            this.log.info((Object)"[Attachment-Mgt OpenJPA] Show SQL enabled.");
            jpaProperties.put("openjpa.Log", "DefaultLevel=WARN, Runtime=INFO, Tool=INFO, SQL=TRACE");
            jpaProperties.put("openjpa.ConnectionFactoryProperties", "PrettyPrint=true, PrettyPrintLineLength=72");
        }
        if (transactionManager != null) {
            jpaProperties.put("openjpa.ConnectionFactoryMode", "managed");
            jpaProperties.put("openjpa.ManagedRuntime", new TransactionManagerProvider(transactionManager));
        }
        jpaProperties.put("openjpa.Id", "Attachment-Mgt-PU");
        jpaProperties.put("openjpa.QueryCache", "false");
        jpaProperties.put("openjpa.DataCache", "false");
        jpaProperties.put("openjpa.jdbc.QuerySQLCache", "false");
        return jpaProperties;
    }

    protected String determineDbDictionary() {
        DatabaseType dbType = this.determineDbType();
        switch (dbType) {
            case DB2: {
                return "db2";
            }
            case DERBY: {
                return "derby";
            }
            case H2: {
                return "h2";
            }
            case HSQL: {
                return "hsql(SimulateLocking=true)";
            }
            case INFORMIX: {
                return "informix";
            }
            case MYSQL: {
                return "mysql";
            }
            case ORACLE: {
                return "oracle";
            }
            case POSTGRESQL: {
                return "postgres";
            }
            case SQL_SERVER: {
                return "sqlserver";
            }
            case SYBASE: {
                return "sybase";
            }
        }
        return null;
    }
}

