/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.attachment.mgt.core.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.attachment.mgt.api.attachment.Attachment;
import org.wso2.carbon.attachment.mgt.client.dto2api.TransformerUtil;
import org.wso2.carbon.attachment.mgt.core.dao.AttachmentDAO;
import org.wso2.carbon.attachment.mgt.core.dao.AttachmentMgtDAOConnectionFactory;
import org.wso2.carbon.attachment.mgt.core.dao.AttachmentMgtDAOTransformerFactory;
import org.wso2.carbon.attachment.mgt.core.exceptions.AttachmentMgtException;
import org.wso2.carbon.attachment.mgt.server.internal.AttachmentServerHolder;
import org.wso2.carbon.attachment.mgt.skeleton.AttachmentMgtServiceSkeletonInterface;
import org.wso2.carbon.attachment.mgt.skeleton.types.TAttachment;

public class AttachmentManagerService
implements AttachmentMgtServiceSkeletonInterface {
    private static Log log = LogFactory.getLog(AttachmentManagerService.class);

    @Override
    public String add(TAttachment attachment) throws org.wso2.carbon.attachment.mgt.skeleton.AttachmentMgtException {
        try {
            Attachment att = TransformerUtil.convertAttachment(attachment);
            AttachmentDAO daoImpl = this.getDaoConnectionFactory().getDAOConnection().getAttachmentMgtDAOFactory().addAttachment(att);
            return daoImpl.getID().toString();
        }
        catch (AttachmentMgtException ex) {
            String errMsg = "org.wso2.carbon.attachment.mgt.core.service.AttachmentManagerService.add operation failed. Reason:" + ex.getLocalizedMessage();
            log.error((Object)errMsg, (Throwable)ex);
            throw new org.wso2.carbon.attachment.mgt.skeleton.AttachmentMgtException(errMsg, ex);
        }
    }

    @Override
    public TAttachment getAttachmentInfo(String id) throws org.wso2.carbon.attachment.mgt.skeleton.AttachmentMgtException {
        try {
            AttachmentDAO attachmentDAO = this.getDaoConnectionFactory().getDAOConnection().getAttachmentMgtDAOFactory().getAttachmentInfo(id);
            Attachment attachment = this.getDaoTransformFactory().convertAttachment(attachmentDAO);
            return TransformerUtil.convertAttachment(attachment);
        }
        catch (AttachmentMgtException e) {
            String errorMsg = "org.wso2.carbon.attachment.mgt.core.service.AttachmentManagerService.getAttachmentInfo operation failed. Reason:" + e.getLocalizedMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new org.wso2.carbon.attachment.mgt.skeleton.AttachmentMgtException(errorMsg, e);
        }
    }

    @Override
    public TAttachment getAttachmentInfoFromURL(String attachmentURL) throws org.wso2.carbon.attachment.mgt.skeleton.AttachmentMgtException {
        try {
            String attachmentUniqueID = attachmentURL.substring(attachmentURL.lastIndexOf("/") + 1);
            AttachmentDAO attachmentDAO = this.getDaoConnectionFactory().getDAOConnection().getAttachmentMgtDAOFactory().getAttachmentInfoFromURL(attachmentUniqueID);
            Attachment attachment = this.getDaoTransformFactory().convertAttachment(attachmentDAO);
            return TransformerUtil.convertAttachment(attachment);
        }
        catch (AttachmentMgtException e) {
            String errorMsg = "org.wso2.carbon.attachment.mgt.core.service.AttachmentManagerService.getAttachmentInfoFromURL operation failed. Reason:" + e.getLocalizedMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new org.wso2.carbon.attachment.mgt.skeleton.AttachmentMgtException(errorMsg, e);
        }
    }

    @Override
    public boolean remove(String id) throws org.wso2.carbon.attachment.mgt.skeleton.AttachmentMgtException {
        try {
            return this.getDaoConnectionFactory().getDAOConnection().getAttachmentMgtDAOFactory().removeAttachment(id);
        }
        catch (AttachmentMgtException e) {
            String errorMsg = "org.wso2.carbon.attachment.mgt.core.service.AttachmentManagerService.remove operation failed. Reason:" + e.getLocalizedMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new org.wso2.carbon.attachment.mgt.skeleton.AttachmentMgtException(errorMsg, e);
        }
    }

    private AttachmentMgtDAOConnectionFactory getDaoConnectionFactory() throws AttachmentMgtException {
        return AttachmentServerHolder.getInstance().getAttachmentServer().getDaoManager().getDAOConnectionFactory();
    }

    private AttachmentMgtDAOTransformerFactory getDaoTransformFactory() throws AttachmentMgtException {
        return AttachmentServerHolder.getInstance().getAttachmentServer().getDaoManager().getDAOTransformerFactory();
    }
}

