/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.attachment.mgt.server;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.attachment.mgt.configuration.AttachmentServerConfiguration;
import org.wso2.carbon.attachment.mgt.core.dao.DAOManagerImpl;
import org.wso2.carbon.attachment.mgt.core.datasource.impl.BasicDataSourceManager;
import org.wso2.carbon.attachment.mgt.core.exceptions.AttachmentMgtException;
import org.wso2.carbon.attachment.mgt.server.AbstractAttachmentServer;
import org.wso2.carbon.utils.CarbonUtils;

public class AttachmentServer
extends AbstractAttachmentServer {
    private static final Log log = LogFactory.getLog(AttachmentServer.class);
    private AttachmentServerConfiguration serverConfig;
    private static AttachmentServer instance = new AttachmentServer();

    private AttachmentServer() {
    }

    public static AttachmentServer getInstance() {
        return instance;
    }

    @Override
    public void init() {
        this.loadAttachmentServerConfig();
        this.initDataSourceManager();
        this.initDAOManager();
    }

    @Override
    public void shutdown() {
        this.shutdownDataSourceManager();
        this.shutdownDAOManager();
        this.unloadAttachmentServerConfig();
    }

    @Override
    public void initDAOManager() {
        this.daoManager = new DAOManagerImpl();
        this.daoManager.init(this.serverConfig);
    }

    @Override
    public void initDataSourceManager() {
        if (this.serverConfig == null) {
            log.error((Object)"Attachment Server configurations are not loaded properly.");
        }
        this.dataSourceManager = new BasicDataSourceManager(this.serverConfig);
        try {
            this.dataSourceManager.start();
        }
        catch (AttachmentMgtException e) {
            log.error((Object)("Data-Source initialization failed. Reason:" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private void loadAttachmentServerConfig() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Loading Attachment Mgt Server Configuration...");
        }
        if (this.isAttachmentMgtConfigurationFileAvailable()) {
            File attMgtConfigFile = new File(this.calculateAttachmentMgtServerConfigurationFilePath());
            this.serverConfig = new AttachmentServerConfiguration(attMgtConfigFile);
        } else {
            log.info((Object)"Humantask configuration file: attach-mgt-conf.properties not found. Loading default configurations.");
            this.serverConfig = new AttachmentServerConfiguration();
        }
    }

    private void unloadAttachmentServerConfig() {
        this.serverConfig = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unloaded Attachment Mgt Server Configuration.");
        }
    }

    private boolean isAttachmentMgtConfigurationFileAvailable() {
        File attMgtConfigFile = new File(this.calculateAttachmentMgtServerConfigurationFilePath());
        return attMgtConfigFile.exists();
    }

    private String calculateAttachmentMgtServerConfigurationFilePath() {
        return CarbonUtils.getCarbonConfigDirPath() + File.separator + "attach-mgt-conf.properties";
    }
}

