/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.attachment.mgt.core.datasource.impl;

import java.io.IOException;
import java.sql.SQLException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.attachment.mgt.configuration.AttachmentServerConfiguration;
import org.wso2.carbon.attachment.mgt.core.datasource.AbstractDataSourceManager;
import org.wso2.carbon.attachment.mgt.core.datasource.impl.JDBCConfiguration;
import org.wso2.carbon.attachment.mgt.core.exceptions.AttachmentMgtException;
import org.wso2.carbon.utils.FileUtil;

public class JDBCManager
extends AbstractDataSourceManager {
    private static Log log = LogFactory.getLog(JDBCManager.class);
    protected JDBCConfiguration jdbcConfiguration;
    protected volatile BasicDataSource dataSource = null;

    public BasicDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public void init(AttachmentServerConfiguration serverConfig) throws AttachmentMgtException {
        log.warn((Object)"Nothing happens at org.wso2.carbon.attachment.mgt.core.datasource.impl.JDBCManager.init");
    }

    @Override
    public void start() throws AttachmentMgtException {
        log.warn((Object)"Nothing happens at org.wso2.carbon.attachment.mgt.core.datasource.impl.JDBCManager.start");
    }

    @Override
    public void shutdown() throws AttachmentMgtException {
        try {
            this.dataSource.close();
            this.dataSource = null;
        }
        catch (SQLException e) {
            throw new AttachmentMgtException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initFromFileConfig(String dbConfigurationPath) throws AttachmentMgtException {
        if (this.dataSource != null) return;
        Class<JDBCManager> clazz = JDBCManager.class;
        synchronized (JDBCManager.class) {
            if (this.dataSource != null) return;
            JDBCConfiguration configuration = JDBCManager.getDBConfig(dbConfigurationPath);
            String jdbcURL = configuration.getJdbcURL();
            String driver = configuration.getDriver();
            String username = configuration.getUsername();
            String password = configuration.getPassword();
            String validationQuery = configuration.getValidationQuery();
            if (jdbcURL == null || driver == null || username == null || password == null) {
                throw new AttachmentMgtException("DB configurations are not properly defined");
            }
            this.dataSource = new BasicDataSource();
            this.dataSource.setDriverClassName(driver);
            this.dataSource.setUrl(jdbcURL);
            this.dataSource.setUsername(username);
            this.dataSource.setPassword(password);
            this.dataSource.setValidationQuery(validationQuery);
            // ** MonitorExit[var7_2] (shouldn't be in output)
            return;
        }
    }

    private static JDBCConfiguration getDBConfig(String configPath) throws AttachmentMgtException {
        String config = null;
        try {
            config = FileUtil.readFileToString((String)configPath);
            OMElement omElement = AXIOMUtil.stringToOM((String)config);
            String dbURL = omElement.getFirstChildWithName(new QName("url")).getText();
            String driverName = omElement.getFirstChildWithName(new QName("driverName")).getText();
            String userName = omElement.getFirstChildWithName(new QName("userName")).getText();
            String password = omElement.getFirstChildWithName(new QName("password")).getText();
            String validationQuery = omElement.getFirstChildWithName(new QName("validationQuery")).getText();
            JDBCConfiguration dbConfiguration = new JDBCConfiguration(dbURL, driverName, userName, password, validationQuery);
            return dbConfiguration;
        }
        catch (IOException e) {
            throw new AttachmentMgtException(e.getLocalizedMessage(), e);
        }
        catch (XMLStreamException e) {
            throw new AttachmentMgtException(e.getLocalizedMessage(), e);
        }
    }
}

