/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.attachment.mgt.core.dao;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.attachment.mgt.configuration.AttachmentServerConfiguration;
import org.wso2.carbon.attachment.mgt.core.dao.AttachmentMgtDAOConnectionFactory;
import org.wso2.carbon.attachment.mgt.core.dao.AttachmentMgtDAOTransformerFactory;
import org.wso2.carbon.attachment.mgt.core.dao.DAOManager;
import org.wso2.carbon.attachment.mgt.server.internal.AttachmentServerHolder;

public abstract class AbstractDAOManager
implements DAOManager {
    private static final Log log = LogFactory.getLog(AbstractDAOManager.class);
    protected AttachmentMgtDAOConnectionFactory daoConnectionFactory;
    protected AttachmentMgtDAOTransformerFactory daoTransformerFactory;
    protected AttachmentServerConfiguration serverConfiguration;

    @Override
    public AttachmentMgtDAOConnectionFactory getDAOConnectionFactory() {
        if (this.daoConnectionFactory != null) {
            return this.daoConnectionFactory;
        }
        log.error((Object)"DAO Connection Factory is not initialized.");
        throw new NullPointerException("DAO Connection Factory is not initialized.");
    }

    @Override
    public AttachmentMgtDAOTransformerFactory getDAOTransformerFactory() {
        if (this.daoTransformerFactory != null) {
            return this.daoTransformerFactory;
        }
        log.error((Object)"DAO Transformer Factory is not initialized.");
        throw new NullPointerException("DAO Transformer Factory is not initialized.");
    }

    @Override
    public void init(AttachmentServerConfiguration serverConfig) {
        this.serverConfiguration = serverConfig;
        this.initDAOConnectionFactory(serverConfig.getDaoConnectionFactoryClass());
        this.initDAOTransformerFactory(serverConfig.getDaoTransformerFactoryClass());
    }

    private void initDAOTransformerFactory(String daoTransformerFactoryClassName) {
        try {
            Class<?> daoTransformerFactoryClass = this.getClass().getClassLoader().loadClass(daoTransformerFactoryClassName);
            Object daoTransformerFactory = daoTransformerFactoryClass.newInstance();
            this.daoTransformerFactory = (AttachmentMgtDAOTransformerFactory)daoTransformerFactory;
        }
        catch (Exception e) {
            log.error((Object)("DAO Transformer Factory creation failed. Reason:" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private void initDAOConnectionFactory(String daoConnectionFactoryClassName) {
        try {
            Class<?> daoConnectionFactoryClass = this.getClass().getClassLoader().loadClass(daoConnectionFactoryClassName);
            Object daoConnectionFactory = daoConnectionFactoryClass.newInstance();
            this.daoConnectionFactory = (AttachmentMgtDAOConnectionFactory)daoConnectionFactory;
            this.daoConnectionFactory.setDataSource(AttachmentServerHolder.getInstance().getAttachmentServer().getDataSourceManager().getDataSource());
            this.daoConnectionFactory.setDAOConnectionFactoryProperties(this.getGenericDAOFactoryProperties());
            this.daoConnectionFactory.init();
        }
        catch (Exception e) {
            log.fatal((Object)("DAO Connection Factory creation failed. Reason:" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private Map<String, Object> getGenericDAOFactoryProperties() {
        HashMap<String, Object> daoFactoryProperties = new HashMap<String, Object>();
        daoFactoryProperties.put("org.wso2.carbon.attachment.mgt.DataSource", AttachmentServerHolder.getInstance().getAttachmentServer().getDataSourceManager().getDataSource());
        daoFactoryProperties.put("org.wso2.carbon.attachment.mgt.DDLGeneration", this.serverConfiguration.isGenerateDdl());
        daoFactoryProperties.put("org.wso2.carbon.attachment.mgt.SQLTracing", this.serverConfiguration.isShowSql());
        daoFactoryProperties.put("org.wso2.carbon.attachment.mgt.DAOFactory", this.serverConfiguration.getDaoConnectionFactoryClass());
        return daoFactoryProperties;
    }

    @Override
    public void shutdown() {
        this.daoConnectionFactory.shutdown();
        this.daoConnectionFactory = null;
    }
}

