/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.attachment.mgt.core.dao.impl.jpa.openjpa;

import java.util.List;
import java.util.concurrent.Callable;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.attachment.mgt.api.attachment.Attachment;
import org.wso2.carbon.attachment.mgt.core.dao.AttachmentDAO;
import org.wso2.carbon.attachment.mgt.core.dao.AttachmentMgtDAOFactory;
import org.wso2.carbon.attachment.mgt.core.dao.impl.jpa.openjpa.entity.AttachmentDAOImpl;
import org.wso2.carbon.attachment.mgt.core.exceptions.AttachmentMgtException;
import org.wso2.carbon.attachment.mgt.core.scheduler.Scheduler;
import org.wso2.carbon.attachment.mgt.util.URLGeneratorUtil;

public class AttachmentMgtDAOFactoryImpl
implements AttachmentMgtDAOFactory {
    private static Log log = LogFactory.getLog(AttachmentMgtDAOFactoryImpl.class);
    private EntityManager entityManager;
    JobExecutor jobExecutor;

    public AttachmentMgtDAOFactoryImpl(EntityManager entityManager) {
        this.entityManager = entityManager;
        this.jobExecutor = new JobExecutor();
    }

    @Override
    public AttachmentDAO addAttachment(final Attachment attachment) throws AttachmentMgtException {
        try {
            AttachmentDAO resultantDAO = this.jobExecutor.execTransaction(new Callable<AttachmentDAO>(){

                @Override
                public AttachmentDAO call() throws Exception {
                    AttachmentDAOImpl attachmentDAO = new AttachmentDAOImpl();
                    attachmentDAO.setName(attachment.getName());
                    attachmentDAO.setCreatedBy(attachment.getCreatedBy());
                    attachmentDAO.setContentType(attachment.getContentType());
                    attachmentDAO.setUrl(URLGeneratorUtil.generateURL());
                    attachmentDAO.setContent(attachment.getContent());
                    AttachmentMgtDAOFactoryImpl.this.entityManager.persist((Object)attachmentDAO);
                    if (AttachmentMgtDAOFactoryImpl.this.entityManager.contains((Object)attachmentDAO)) {
                        return attachmentDAO;
                    }
                    String errorMsg = "Attachment couldn't persist in the Data Store";
                    throw new AttachmentMgtException(errorMsg);
                }
            });
            return resultantDAO;
        }
        catch (Exception e) {
            String errorMsg = "org.wso2.carbon.attachment.mgt.core.dao.impl.jpa.openjpa.AttachmentMgtDAOFactoryImpl.addAttachment operation failed. Reason: " + e.getLocalizedMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new AttachmentMgtException(errorMsg, e);
        }
    }

    @Override
    public AttachmentDAO getAttachmentInfo(final String id) throws AttachmentMgtException {
        try {
            AttachmentDAO resultantDAO = this.jobExecutor.execTransaction(new Callable<AttachmentDAO>(){

                @Override
                public AttachmentDAO call() throws Exception {
                    AttachmentDAO attachmentDAO = null;
                    attachmentDAO = (AttachmentDAO)AttachmentMgtDAOFactoryImpl.this.entityManager.find(AttachmentDAOImpl.class, (Object)id);
                    return attachmentDAO;
                }
            });
            if (resultantDAO != null) {
                return resultantDAO;
            }
            throw new AttachmentMgtException("Attachment not found for id : " + id);
        }
        catch (Exception e) {
            String errorMsg = "org.wso2.carbon.attachment.mgt.core.dao.impl.jpa.openjpa.AttachmentMgtDAOFactoryImpl.getAttachmentInfo operation failed. Reason: " + e.getLocalizedMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new AttachmentMgtException(errorMsg, e);
        }
    }

    @Override
    public boolean removeAttachment(final String id) throws AttachmentMgtException {
        try {
            boolean isRemoved = false;
            isRemoved = this.jobExecutor.execTransaction(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    Query query = AttachmentMgtDAOFactoryImpl.this.entityManager.createQuery("DELETE FROM org.wso2.carbon.attachment.mgt.core.dao.impl.jpa.openjpa.entity.AttachmentDAOImpl x WHERE x.id = :attachmentID");
                    query.setParameter("attachmentID", (Object)Long.parseLong(id));
                    int noOfRowsUpdated = query.executeUpdate();
                    if (noOfRowsUpdated == 1) {
                        return true;
                    }
                    return false;
                }
            });
            return isRemoved;
        }
        catch (Exception e) {
            String errorMsg = "org.wso2.carbon.attachment.mgt.core.dao.impl.jpa.openjpa.AttachmentMgtDAOFactoryImpl.removeAttachment operation failed. Reason: " + e.getLocalizedMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new AttachmentMgtException(errorMsg, e);
        }
    }

    @Override
    public AttachmentDAO getAttachmentInfoFromURL(final String attachmentURI) throws AttachmentMgtException {
        try {
            AttachmentDAO resultantDAO = this.jobExecutor.execTransaction(new Callable<AttachmentDAO>(){

                @Override
                public AttachmentDAO call() throws Exception {
                    Query query = AttachmentMgtDAOFactoryImpl.this.entityManager.createQuery("SELECT x FROM org.wso2.carbon.attachment.mgt.core.dao.impl.jpa.openjpa.entity.AttachmentDAOImpl AS x WHERE x.url = :attachmentURI");
                    query.setParameter("attachmentURI", (Object)attachmentURI);
                    List daoList = query.getResultList();
                    if (daoList.isEmpty()) {
                        throw new AttachmentMgtException("Attachment not found for the uri:" + attachmentURI);
                    }
                    if (daoList.size() != 1) {
                        String errorMsg = "There exist more than one attachment for the attachment URI:" + attachmentURI + ". org" + ".wso2.carbon.attachment.mgt.util.URLGeneratorUtil.generateURL method has generated " + "similar uris for different attachments. This has caused a major inconsistency for " + "attachment management.";
                        log.fatal((Object)errorMsg);
                        throw new AttachmentMgtException(errorMsg);
                    }
                    return (AttachmentDAO)daoList.get(0);
                }
            });
            return resultantDAO;
        }
        catch (Exception e) {
            String errorMsg = "org.wso2.carbon.attachment.mgt.core.dao.impl.jpa.openjpa.AttachmentMgtDAOFactoryImpl.getAttachmentInfoFromURL operation failed. Reason: " + e.getLocalizedMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new AttachmentMgtException(errorMsg, e);
        }
    }

    class JobExecutor
    implements Scheduler {
        JobExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T execTransaction(Callable<T> transaction) throws Exception {
            Exception ex = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Beginning a new transaction");
                }
                AttachmentMgtDAOFactoryImpl.this.entityManager.getTransaction().begin();
            }
            catch (Exception e) {
                String errMsg = "Internal Error, could not begin transaction. Reason : " + e.getLocalizedMessage();
                throw new AttachmentMgtException(errMsg, e);
            }
            try {
                ex = null;
                T e = transaction.call();
                return e;
            }
            catch (Exception e) {
                ex = e;
            }
            finally {
                if (ex == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Committing on " + AttachmentMgtDAOFactoryImpl.this.entityManager.getTransaction() + "..."));
                    }
                    try {
                        AttachmentMgtDAOFactoryImpl.this.entityManager.getTransaction().commit();
                    }
                    catch (Exception e2) {
                        ex = e2;
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Rollback on " + AttachmentMgtDAOFactoryImpl.this.entityManager.getTransaction() + "..."));
                    }
                    AttachmentMgtDAOFactoryImpl.this.entityManager.getTransaction().rollback();
                }
            }
            throw ex;
        }
    }
}

