/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.attachment.mgt.client.dto2api;

import java.util.Calendar;
import org.apache.axis2.databinding.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.attachment.mgt.api.attachment.Attachment;
import org.wso2.carbon.attachment.mgt.core.AttachmentImpl;
import org.wso2.carbon.attachment.mgt.core.exceptions.AttachmentMgtException;
import org.wso2.carbon.attachment.mgt.skeleton.types.TAttachment;

public class TransformerUtil {
    private static Log log = LogFactory.getLog(TransformerUtil.class);

    public static Attachment convertAttachment(TAttachment attachment) throws AttachmentMgtException {
        AttachmentImpl attachmentDTO = null;
        attachmentDTO = new AttachmentImpl(attachment.getName(), attachment.getCreatedBy(), attachment.getContentType(), attachment.getContent());
        return attachmentDTO;
    }

    public static TAttachment convertAttachment(Attachment attachment) throws AttachmentMgtException {
        TAttachment attachmentDTO = new TAttachment();
        attachmentDTO.setId(attachment.getId());
        attachmentDTO.setName(attachment.getName());
        attachmentDTO.setCreatedBy(attachment.getCreatedBy());
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(attachment.getCreatedTime());
        attachmentDTO.setCreatedTime(cal);
        attachmentDTO.setContentType(attachment.getContentType());
        attachmentDTO.setContent(attachment.getContent());
        try {
            URI attachmentURI = new URI(attachment.getURL().toString());
            attachmentDTO.setUrl(attachmentURI);
        }
        catch (URI.MalformedURIException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new AttachmentMgtException("Conversion of Attachment to TAttachment (DTO) failed due to reason : " + e.getLocalizedMessage(), e);
        }
        return attachmentDTO;
    }
}

