/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.attachment.mgt.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.attachment.mgt.core.dao.DAOManager;
import org.wso2.carbon.attachment.mgt.core.datasource.AbstractDataSourceManager;
import org.wso2.carbon.attachment.mgt.core.exceptions.AttachmentMgtException;
import org.wso2.carbon.attachment.mgt.server.Server;

public abstract class AbstractAttachmentServer
implements Server {
    private static Log log = LogFactory.getLog(AbstractAttachmentServer.class);
    protected DAOManager daoManager;
    protected AbstractDataSourceManager dataSourceManager;

    @Override
    public DAOManager getDaoManager() {
        if (this.daoManager != null) {
            return this.daoManager;
        }
        log.error((Object)"daoManager is not initialized yet.");
        throw new NullPointerException("daoManager is not initialized yet.");
    }

    @Override
    public AbstractDataSourceManager getDataSourceManager() {
        if (this.dataSourceManager != null) {
            return this.dataSourceManager;
        }
        log.error((Object)"dataSourceManager is not initialized yet.");
        throw new NullPointerException("dataSourceManager is not initialized yet.");
    }

    @Override
    public void shutdownDataSourceManager() {
        try {
            this.dataSourceManager.shutdown();
            this.dataSourceManager = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Data-Source Manager was shut-down.");
            }
        }
        catch (AttachmentMgtException e) {
            log.error((Object)("Data-Source shutdown failed. Reason:" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    @Override
    public void shutdownDAOManager() {
        this.daoManager.shutdown();
        this.daoManager = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"DAO Manager was shut-down.");
        }
    }
}

