/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.attachment.mgt.core.dao.impl.jpa.openjpa;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openjpa.persistence.ArgumentException;
import org.wso2.carbon.attachment.mgt.core.dao.AttachmentMgtDAOConnection;
import org.wso2.carbon.attachment.mgt.core.dao.impl.jpa.JPABasedAttachmentMgtDAOConnectionFactory;
import org.wso2.carbon.attachment.mgt.core.dao.impl.jpa.JPAVendorAdapter;
import org.wso2.carbon.attachment.mgt.core.dao.impl.jpa.openjpa.AttachmentMgtDAOConnectionImpl;
import org.wso2.carbon.attachment.mgt.core.dao.impl.jpa.openjpa.OpenJPAVendorAdapter;

public class AttachmentMgtDAOConnectionFactoryImpl
implements JPABasedAttachmentMgtDAOConnectionFactory {
    private static Log log = LogFactory.getLog(AttachmentMgtDAOConnectionFactoryImpl.class);
    protected EntityManagerFactory entityManagerFactory;
    private DataSource dataSource;
    private TransactionManager transactionManager;
    private Map<String, Object> jpaPropertiesMap;
    private static ThreadLocal<AttachmentMgtDAOConnectionImpl> connections = new ThreadLocal();

    @Override
    public AttachmentMgtDAOConnection getDAOConnection() {
        if (connections.get() != null) {
            return connections.get();
        }
        try {
            EntityManager entityManager = this.entityManagerFactory.createEntityManager();
            AttachmentMgtDAOConnectionImpl conn = this.createAttachmentMgtDAOConnection(entityManager);
            connections.set(conn);
            return conn;
        }
        catch (ArgumentException argEx) {
            log.fatal((Object)"Entity-Manager creation failed.", (Throwable)argEx);
            throw argEx;
        }
    }

    protected AttachmentMgtDAOConnectionImpl createAttachmentMgtDAOConnection(EntityManager entityManager) {
        return new AttachmentMgtDAOConnectionImpl(entityManager);
    }

    @Override
    public void init() {
        if (this.transactionManager == null) {
            log.debug((Object)"Transaction-Manager is not initialized before initializing entityManager. So internal transaction-manager in entity manager will be used.");
        }
        JPAVendorAdapter vendorAdapter = this.getJPAVendorAdapter();
        this.entityManagerFactory = Persistence.createEntityManagerFactory((String)"Attachment-Mgt-PU", vendorAdapter.getJpaPropertyMap(null));
    }

    @Override
    public void shutdown() {
        this.entityManagerFactory.close();
    }

    @Override
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void setDAOConnectionFactoryProperties(Map<String, Object> propertiesMap) {
        this.jpaPropertiesMap = propertiesMap;
    }

    @Override
    public void setTransactionManager(TransactionManager tnxManager) {
        this.transactionManager = tnxManager;
    }

    private JPAVendorAdapter getJPAVendorAdapter() {
        OpenJPAVendorAdapter vendorAdapter = new OpenJPAVendorAdapter();
        if (this.dataSource != null) {
            vendorAdapter.setDataSource(this.dataSource);
        } else {
            log.error((Object)"DataSource is not initialized prior to initializing JPAVendorAdapter.");
        }
        Object generateDDL = this.jpaPropertiesMap.get("org.wso2.carbon.attachment.mgt.DDLGeneration");
        Object showSQL = this.jpaPropertiesMap.get("org.wso2.carbon.attachment.mgt.SQLTracing");
        if (generateDDL == null) {
            generateDDL = Boolean.FALSE.toString();
        }
        if (showSQL == null) {
            showSQL = Boolean.FALSE.toString();
        }
        vendorAdapter.setGenerateDdl(Boolean.parseBoolean(generateDDL.toString()));
        vendorAdapter.setShowSql(Boolean.parseBoolean(showSQL.toString()));
        return vendorAdapter;
    }
}

