/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.attachment.mgt.util;

import java.math.BigInteger;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.security.SecureRandom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.attachment.mgt.core.exceptions.AttachmentMgtException;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.utils.NetworkUtils;

public class URLGeneratorUtil
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(URLGeneratorUtil.class);
    private static final SecureRandom random = new SecureRandom();

    public static String generateURL() throws AttachmentMgtException {
        return URLGeneratorUtil.generateUniqueID();
    }

    private static String generateUniqueID() {
        return new BigInteger(130, random).toString(32);
    }

    public static URL getPermanentLink(URI uniqueID) throws AttachmentMgtException {
        String scheme = "https";
        try {
            String host = NetworkUtils.getLocalHostname();
        }
        catch (SocketException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AttachmentMgtException(e.getLocalizedMessage(), e);
        }
        log.warn((Object)"Port is hardcoded.");
        int port = 9443;
        String webContext = ServerConfiguration.getInstance().getFirstProperty("WebContextRoot");
        if (webContext == null || webContext.equals("/")) {
            webContext = "";
        }
        String tenantDomain = String.valueOf(-1234);
        try {
            tenantDomain = SuperTenantCarbonContext.getCurrentContext().getTenantDomain(true);
        }
        finally {
            Object url = null;
        }
    }
}

