/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.attachment.mgt.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationUtil {
    private static Log log = LogFactory.getLog(ConfigurationUtil.class);

    public static String getConfigValue(File propertyFileLocation, String propertyKey) {
        String value = "Error:VALUE_IS_NOT_DEFINED";
        try {
            Properties prop = ConfigurationUtil.getPropertyMap(propertyFileLocation);
            value = prop.getProperty(propertyKey);
            if (value != null) {
                value = value.trim();
            }
        }
        catch (IOException ex) {
            log.error((Object)("Failed to load property value of " + propertyKey), (Throwable)ex);
        }
        return value;
    }

    public static Properties getPropertyMap(File propertyFileLocation) throws IOException {
        File configFile = propertyFileLocation;
        try {
            Properties prop = new Properties();
            prop.load(new FileInputStream(configFile));
            return prop;
        }
        catch (IOException ex) {
            log.error((Object)("Failed to load property file:" + configFile.getAbsolutePath()), (Throwable)ex);
            throw ex;
        }
    }
}

