/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.attachment.mgt.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.attachment.mgt.core.service.AttachmentManagerService;
import org.wso2.carbon.attachment.mgt.skeleton.AttachmentMgtException;
import org.wso2.carbon.attachment.mgt.skeleton.types.TAttachment;

public class AttachmentDownloadServlet
extends HttpServlet {
    private static Log log = LogFactory.getLog(AttachmentDownloadServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String url = request.getRequestURI();
        String attachmentUniqueID = url.substring(url.lastIndexOf("/") + 1);
        InputStream contentStream = null;
        ServletOutputStream servletOutputStream = null;
        try {
            TAttachment fileAttachment = this.getFileFromUniqueID(url);
            response.setHeader("Content-Disposition", "attachment; filename=" + fileAttachment.getName());
            response.setContentType(fileAttachment.getContentType());
            contentStream = fileAttachment.getContent().getInputStream();
            servletOutputStream = response.getOutputStream();
            IOUtils.copy((InputStream)contentStream, (OutputStream)servletOutputStream);
            servletOutputStream.flush();
        }
        catch (AttachmentMgtException e) {
            try {
                throw new ServletException(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(contentStream);
                IOUtils.closeQuietly(servletOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)contentStream);
        IOUtils.closeQuietly((OutputStream)servletOutputStream);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private TAttachment getFileFromUniqueID(String attachmentURL) throws AttachmentMgtException {
        AttachmentManagerService service = new AttachmentManagerService();
        try {
            TAttachment attachment = service.getAttachmentInfoFromURL(attachmentURL);
            return attachment;
        }
        catch (AttachmentMgtException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
    }
}

