/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.attachment.mgt.server.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.attachment.mgt.server.AttachmentServer;
import org.wso2.carbon.attachment.mgt.server.AttachmentServerService;
import org.wso2.carbon.attachment.mgt.server.AttachmentServerServiceImpl;
import org.wso2.carbon.attachment.mgt.server.internal.AttachmentServerHolder;
import org.wso2.carbon.attachment.mgt.servlet.AttachmentDownloadServlet;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.datasource.DataSourceInformationRepositoryService;

public class AttachmentServiceComponent {
    private static final Log log = LogFactory.getLog(AttachmentServiceComponent.class);
    private boolean dataSourceInfoRepoProvided = false;
    private BundleContext bundleContext;

    protected void activate(ComponentContext componentContext) {
        try {
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(-1234);
            this.bundleContext = componentContext.getBundleContext();
            if (this.dataSourceInfoRepoProvided) {
                this.initAttachmentServer();
                this.registerAttachmentDownloadServlet();
                this.registerAttachmentServerService();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to activate Attachment management bundle", t);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Attachment management bundle is activated.");
        }
    }

    private void initAttachmentServer() {
        AttachmentServerHolder.getInstance().setAttachmentServer(AttachmentServer.getInstance());
        log.info((Object)"Initialising Attachment Server");
        AttachmentServerHolder.getInstance().getAttachmentServer().init();
    }

    private void registerAttachmentServerService() {
        log.info((Object)"Registering AttachmentServerService");
        this.bundleContext.registerService(AttachmentServerService.class.getName(), (Object)new AttachmentServerServiceImpl(), null);
    }

    private void registerAttachmentDownloadServlet() {
        AttachmentDownloadServlet attachmentDownloadServlet = new AttachmentDownloadServlet();
        Hashtable<String, String> redirectorParams = new Hashtable<String, String>(1);
        ((Dictionary)redirectorParams).put("url-pattern", "/attachment-mgt/download");
        this.bundleContext.registerService(Servlet.class.getName(), (Object)attachmentDownloadServlet, redirectorParams);
        log.info((Object)"Attachment Download Servlet registered.");
    }

    protected void deactivate(ComponentContext componentContext) {
        log.info((Object)"org.wso2.carbon.attachment.mgt.server.internal.AttachmentServiceComponent.deactivate");
        throw new UnsupportedOperationException("org.wso2.carbon.attachment.mgt.server.internal.AttachmentServiceComponent.deactivate");
    }

    protected void setDataSourceInformationRepositoryService(DataSourceInformationRepositoryService repositoryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"DataSourceInformationRepositoryService bound to the Attachment-Mgt component");
        }
        this.dataSourceInfoRepoProvided = true;
    }

    protected void unsetDataSourceInformationRepositoryService(DataSourceInformationRepositoryService repositoryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"DataSourceInformationRepositoryService unbound from the Attachment-Mgt component");
        }
        this.dataSourceInfoRepoProvided = false;
    }
}

