/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.attachment.mgt.core.datasource.impl;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.attachment.mgt.configuration.AttachmentServerConfiguration;
import org.wso2.carbon.attachment.mgt.core.datasource.AbstractDataSourceManager;
import org.wso2.carbon.attachment.mgt.core.datasource.impl.BasicDataSourceConfiguration;
import org.wso2.carbon.attachment.mgt.core.exceptions.AttachmentMgtException;

public class BasicDataSourceManager
extends AbstractDataSourceManager {
    private static Log log = LogFactory.getLog(BasicDataSourceManager.class);
    private BasicDataSourceConfiguration dataSourceConfig;
    private boolean started;

    public BasicDataSourceManager(AttachmentServerConfiguration serverConfig) {
        this.init(serverConfig);
    }

    @Override
    public void init(AttachmentServerConfiguration serverConfig) {
        this.loadDataSourceConfiguration(serverConfig.getDataSourceName(), serverConfig.getDataSourceJNDIRepoInitialContextFactory(), serverConfig.getDataSourceJNDIRepoProviderURL());
    }

    @Override
    public void start() {
        this.startDataSource();
    }

    @Override
    public void shutdown() throws AttachmentMgtException {
        this.dataSource = null;
        this.dataSourceConfig = null;
    }

    private void loadDataSourceConfiguration(String dataSourceName, String dataSourceJNDIRepoInitialContextFactory, String dataSourceJNDIRepoProviderURL) {
        this.dataSourceConfig = new BasicDataSourceConfiguration(dataSourceName, dataSourceJNDIRepoInitialContextFactory, dataSourceJNDIRepoProviderURL);
    }

    private synchronized void startDataSource() {
        if (this.started) {
            return;
        }
        this.dataSource = null;
        this.initDataSource();
    }

    private void initDataSource() {
        this.initExternalDb();
    }

    private void initExternalDb() {
        try {
            this.dataSource = this.lookupInJNDI(this.dataSourceConfig.getDataSourceName());
        }
        catch (NamingException e) {
            log.error((Object)("Could not initialize the DataSource:" + this.dataSourceConfig.getDataSourceName()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource lookupInJNDI(String remoteObjectName) throws NamingException {
        InitialContext ctx = null;
        try {
            if (this.dataSourceConfig.getDataSourceJNDIRepoInitialContextFactory() != null && this.dataSourceConfig.getDataSourceJNDIRepoProviderURL() != null) {
                Properties jndiProps = new Properties();
                jndiProps.setProperty("java.naming.factory.initial", this.dataSourceConfig.getDataSourceJNDIRepoInitialContextFactory());
                jndiProps.setProperty("java.naming.provider.url", this.dataSourceConfig.getDataSourceJNDIRepoProviderURL());
                ctx = new InitialContext(jndiProps);
            } else {
                ctx = new InitialContext();
            }
            DataSource dataSource = (DataSource)ctx.lookup(remoteObjectName);
            return dataSource;
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Exception ex1) {
                    log.error((Object)"Error closing JNDI connection.", (Throwable)ex1);
                }
            }
        }
    }
}

