/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.attachment.mgt.core.dao.impl.jdbc.dao;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.attachment.mgt.api.attachment.Attachment;
import org.wso2.carbon.attachment.mgt.core.dao.AttachmentDAO;
import org.wso2.carbon.attachment.mgt.core.dao.AttachmentMgtDAOFactory;
import org.wso2.carbon.attachment.mgt.core.exceptions.AttachmentMgtException;
import org.wso2.carbon.attachment.mgt.util.URLGeneratorUtil;

public class AttachmentMgtDAOFactoryImpl
implements AttachmentMgtDAOFactory {
    private static Log log = LogFactory.getLog(AttachmentMgtDAOFactoryImpl.class);
    private Connection connection;
    private ResultSet resultSet;
    private PreparedStatement statement;

    public AttachmentMgtDAOFactoryImpl(Connection connection) {
        this.connection = connection;
    }

    @Override
    public AttachmentDAO addAttachment(Attachment attachment) throws AttachmentMgtException {
        String name = "JDBC Sample Name";
        String owner = "JDBC Sample Author";
        String contentType = "JDBC Sample Content Type";
        int instanceID = 789;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(new File("/home/denis/Desktop/note.txt"));
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        String insertAttachment = "INSERT INTO ATTACHMENT (NAME, CREATED_BY, CONTENT_TYPE, INSTANCE_ID, URL, CONTENT) VALUES (?,?,?,?,?,?)";
        try {
            log.warn((Object)"Having connection at Class level is wrong here.");
            this.statement = this.connection.prepareStatement(insertAttachment);
            this.statement.setString(1, name);
            this.statement.setString(2, owner);
            this.statement.setString(3, contentType);
            this.statement.setInt(4, instanceID);
            this.statement.setString(5, URLGeneratorUtil.generateURL());
            log.warn((Object)"URL generation part should be properly implemented.");
            this.statement.setBlob(6, stream);
            log.warn((Object)"Please check this cast can be avoid with good design patterns.");
            this.statement.executeUpdate();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public AttachmentDAO getAttachmentInfo(String id) throws AttachmentMgtException {
        String errorMsg = "org.wso2.carbon.attachment.mgt.core.dao.impl.jdbc.dao.AttachmentMgtDAOFactoryImpl.getAttachmentInfo is still not implemented";
        log.error((Object)errorMsg);
        throw new UnsupportedOperationException(errorMsg);
    }

    @Override
    public boolean removeAttachment(String id) throws AttachmentMgtException {
        String errorMsg = "org.wso2.carbon.attachment.mgt.core.dao.impl.jdbc.dao.AttachmentMgtDAOFactoryImpl.removeAttachment is still not implemented";
        log.error((Object)errorMsg);
        throw new UnsupportedOperationException(errorMsg);
    }

    @Override
    public AttachmentDAO getAttachmentInfoFromURL(String attachmentURI) throws AttachmentMgtException {
        String errorMsg = "org.wso2.carbon.attachment.mgt.core.dao.impl.jdbc.dao.AttachmentMgtDAOFactoryImpl.getAttachmentInfoFromURL is still not implemented";
        log.error((Object)errorMsg);
        throw new UnsupportedOperationException(errorMsg);
    }
}

