/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.attachment.mgt.core.dao.impl;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openjpa.ee.ManagedRuntime;
import org.apache.openjpa.util.GeneralException;

public class TransactionManagerProvider
implements ManagedRuntime {
    private static final Log log = LogFactory.getLog(TransactionManagerProvider.class);
    private TransactionManager transactionManager;

    public TransactionManagerProvider(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public TransactionManager getTransactionManager() throws Exception {
        if (this.transactionManager != null) {
            return this.transactionManager;
        }
        String errorMsg = "transactionManager is not initialized properly.";
        NullPointerException npe = new NullPointerException(errorMsg);
        log.error((Object)errorMsg, (Throwable)npe);
        throw npe;
    }

    public void setRollbackOnly(Throwable cause) throws Exception {
        this.getTransactionManager().getTransaction().setRollbackOnly();
    }

    public Throwable getRollbackCause() throws Exception {
        return null;
    }

    public Object getTransactionKey() throws Exception, SystemException {
        return this.transactionManager.getTransaction();
    }

    public void doNonTransactionalWork(Runnable runnable) throws NotSupportedException {
        TransactionManager transactionManager = null;
        Transaction transaction = null;
        try {
            transactionManager = this.getTransactionManager();
            transaction = transactionManager.suspend();
        }
        catch (Exception e) {
            NotSupportedException nse = new NotSupportedException(e.getMessage());
            nse.initCause((Throwable)e);
            log.error((Object)nse.getLocalizedMessage(), (Throwable)nse);
            throw nse;
        }
        runnable.run();
        try {
            transactionManager.resume(transaction);
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            try {
                transaction.setRollbackOnly();
            }
            catch (SystemException se2) {
                throw new GeneralException((Throwable)se2);
            }
            NotSupportedException nse = new NotSupportedException(e.getMessage());
            nse.initCause((Throwable)e);
            throw nse;
        }
    }
}

