/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.attachment.mgt.configuration;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.attachment.mgt.util.ConfigurationUtil;
import org.wso2.carbon.utils.CarbonUtils;

public class AttachmentServerConfiguration {
    private static Log log = LogFactory.getLog(AttachmentServerConfiguration.class);
    private String dataSourceName;
    private String dataSourceJNDIRepoInitialContextFactory;
    private String dataSourceJNDIRepoProviderURL;
    private String daoConnectionFactoryClass;
    private String daoTransformerFactoryClass;
    private String transactionFactoryClass;
    private boolean generateDdl;
    private boolean showSql;

    public AttachmentServerConfiguration() {
        this.dataSourceName = "attachmentds";
        this.dataSourceJNDIRepoInitialContextFactory = null;
        this.dataSourceJNDIRepoProviderURL = null;
        this.daoConnectionFactoryClass = "org.wso2.carbon.attachment.mgt.core.dao.impl.jpa.openjpa.AttachmentMgtDAOConnectionFactoryImpl";
        this.daoTransformerFactoryClass = "org.wso2.carbon.attachment.mgt.core.dao.impl.jpa.openjpa.AttachmentMgtDAOTransformerFactoryImpl";
        this.transactionFactoryClass = null;
        this.generateDdl = true;
        this.showSql = false;
    }

    public AttachmentServerConfiguration(File attMgtConfigFile) {
        try {
            Properties serverConfigProperties = ConfigurationUtil.getPropertyMap(attMgtConfigFile);
            this.dataSourceName = serverConfigProperties.getProperty("datasource.name");
            this.dataSourceJNDIRepoInitialContextFactory = serverConfigProperties.getProperty("datasource.JNDI.contextFactory");
            if (serverConfigProperties.getProperty("datasource.JNID.providerURL") != null) {
                this.dataSourceJNDIRepoProviderURL = this.applyPortOffset(serverConfigProperties.getProperty("datasource.JNID.providerURL"));
            }
            this.daoConnectionFactoryClass = serverConfigProperties.getProperty("dao.connection.factory.impl.class");
            this.daoTransformerFactoryClass = serverConfigProperties.getProperty("dao.transformer.factory.impl.class");
            this.transactionFactoryClass = serverConfigProperties.getProperty("transaction.factory.class");
            this.generateDdl = Boolean.parseBoolean(serverConfigProperties.getProperty("dao.PersistenceConfig.GenerateDdl"));
            this.showSql = Boolean.parseBoolean(serverConfigProperties.getProperty("dao.PersistenceConfig.ShowSql"));
        }
        catch (IOException e) {
            log.error((Object)"Failed to load Attachment Mgt server configuration file.", (Throwable)e);
        }
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDataSourceJNDIRepoInitialContextFactory() {
        return this.dataSourceJNDIRepoInitialContextFactory;
    }

    public String getDataSourceJNDIRepoProviderURL() {
        return this.dataSourceJNDIRepoProviderURL;
    }

    public String getDaoConnectionFactoryClass() {
        return this.daoConnectionFactoryClass;
    }

    public String getDaoTransformerFactoryClass() {
        return this.daoTransformerFactoryClass;
    }

    public String getTransactionFactoryClass() {
        return this.transactionFactoryClass;
    }

    public boolean isGenerateDdl() {
        return this.generateDdl;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    private String applyPortOffset(String url) {
        int portOffset = this.getCarbonPortOffset();
        String portValueString = url.substring(url.lastIndexOf(58) + 1, url.length());
        String urlWithoutPort = url.substring(0, url.lastIndexOf(58) + 1);
        int actualPortValue = Integer.parseInt(portValueString);
        int correctedPortValue = actualPortValue + portOffset;
        return urlWithoutPort.concat(Integer.toString(correctedPortValue));
    }

    private int getCarbonPortOffset() {
        String offset = CarbonUtils.getServerConfiguration().getFirstProperty("Ports.Offset");
        try {
            return offset != null ? Integer.parseInt(offset.trim()) : 0;
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Error occurred while reading port offset. Invalid port offset: " + offset + " Setting the port offset to 0"), (Throwable)e);
            return 0;
        }
    }
}

