/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.mgt;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.deployer.config.CappFile;
import org.wso2.carbon.application.deployer.config.RegistryConfig;
import org.wso2.carbon.application.deployer.persistence.CarbonAppPersistenceManager;
import org.wso2.carbon.application.mgt.ApplicationMetadata;
import org.wso2.carbon.application.mgt.Association;
import org.wso2.carbon.application.mgt.RegistryMetadata;
import org.wso2.carbon.application.mgt.ServiceGroupMetadata;
import org.wso2.carbon.application.mgt.internal.AppManagementServiceComponent;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.util.SystemFilter;

public class ApplicationAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(ApplicationAdmin.class);

    public String[] listAllApplications() throws Exception {
        String tenantId = AppDeployerUtils.getTenantIdString((AxisConfiguration)this.getAxisConfig());
        ArrayList appList = AppManagementServiceComponent.getAppManager().getCarbonApps(tenantId);
        ArrayList<String> existingApps = new ArrayList<String>();
        for (CarbonApplication anAppList : appList) {
            CarbonApplication tempApp = anAppList;
            if (!tempApp.isDeploymentCompleted()) continue;
            existingApps.add(tempApp.getAppName());
        }
        return existingApps.toArray(new String[existingApps.size()]);
    }

    public void deleteApplication(String appName) throws Exception {
        if (appName == null) {
            this.handleException("Application name can't be null");
            return;
        }
        CarbonApplication currentApp = null;
        String tenantId = AppDeployerUtils.getTenantIdString((AxisConfiguration)this.getAxisConfig());
        ArrayList appList = AppManagementServiceComponent.getAppManager().getCarbonApps(tenantId);
        for (CarbonApplication carbonApp : appList) {
            if (!appName.equals(carbonApp.getAppName())) continue;
            currentApp = carbonApp;
        }
        if (currentApp == null) {
            this.handleException("No Carbon Application found of the name : " + appName);
            return;
        }
        String appFilePath = currentApp.getAppFilePath();
        File file = new File(appFilePath);
        if (file.exists() && !file.delete()) {
            log.error((Object)("Artifact file couldn't be deleted for Application : " + currentApp.getAppName()));
        }
    }

    public ApplicationMetadata getAppData(String appName) throws Exception {
        if (appName == null) {
            this.handleException("Application name can't be null");
            return null;
        }
        ApplicationMetadata appData = new ApplicationMetadata();
        CarbonApplication currentApplication = null;
        String tenantId = AppDeployerUtils.getTenantIdString((AxisConfiguration)this.getAxisConfig());
        ArrayList appList = AppManagementServiceComponent.getAppManager().getCarbonApps(tenantId);
        for (CarbonApplication application : appList) {
            if (!appName.equals(application.getAppName())) continue;
            appData.setAppName(appName);
            currentApplication = application;
            break;
        }
        if (currentApplication == null) {
            this.handleException("No Carbon Application found of the name : " + appName);
            return null;
        }
        String appVersion = currentApplication.getAppVersion();
        if (appVersion != null) {
            appData.setAppVersion(appVersion);
        }
        ArrayList<ServiceGroupMetadata> serviceGroups = new ArrayList<ServiceGroupMetadata>();
        ArrayList<RegistryMetadata> regArtifacts = new ArrayList<RegistryMetadata>();
        ArrayList<String> regFilterList = new ArrayList<String>();
        ArrayList<String> regHandlerList = new ArrayList<String>();
        List dependencies = currentApplication.getAppConfig().getApplicationArtifact().getDependencies();
        for (Artifact.Dependency dependency : dependencies) {
            Artifact artifact = dependency.getArtifact();
            String type = artifact.getType();
            String instanceName = artifact.getRuntimeObjectName();
            if ("service/axis2".equals(type) || "service/dataservice".equals(type)) {
                AxisService axisService;
                AxisServiceGroup sg;
                if (instanceName == null) {
                    sg = this.findServiceGroupForArtifact(artifact);
                    if (sg != null) {
                        artifact.setRuntimeObjectName(sg.getServiceGroupName());
                    }
                } else {
                    sg = this.getAxisConfig().getServiceGroup(instanceName);
                }
                if (sg == null) continue;
                ServiceGroupMetadata sgMetadata = new ServiceGroupMetadata();
                sgMetadata.setSgName(sg.getServiceGroupName());
                sgMetadata.setSgType(type);
                ArrayList<String> services = new ArrayList<String>();
                Iterator serviceIter = sg.getServices();
                while (serviceIter.hasNext() && !(axisService = (AxisService)serviceIter.next()).isClientSide()) {
                    services.add(axisService.getName());
                }
                sgMetadata.setServices(services.toArray(new String[services.size()]));
                serviceGroups.add(sgMetadata);
                continue;
            }
            if ("registry/resource".equals(type)) {
                RegistryConfig regConf = artifact.getRegConfig();
                if (regConf == null) {
                    regConf = this.readRegConfig(currentApplication.getAppName(), artifact.getName());
                }
                if (regConf == null) continue;
                artifact.setRegConfig(regConf);
                RegistryMetadata regMeta = new RegistryMetadata();
                regMeta.setArtifactName(artifact.getName());
                ArrayList<String> resources = new ArrayList<String>();
                ArrayList<String> dumps = new ArrayList<String>();
                ArrayList<String> collections = new ArrayList<String>();
                ArrayList<Association> associations = new ArrayList<Association>();
                for (RegistryConfig.Resourse resourse : regConf.getResources()) {
                    resources.add(resourse.getPath() + "/" + resourse.getFileName());
                }
                for (RegistryConfig.Dump dump : regConf.getDumps()) {
                    dumps.add(dump.getPath());
                }
                for (RegistryConfig.Collection collection : regConf.getCollections()) {
                    collections.add(collection.getPath());
                }
                for (RegistryConfig.Association association : regConf.getAssociations()) {
                    Association assoMeta = new Association(association.getSourcePath(), association.getTargetPath());
                    associations.add(assoMeta);
                }
                if (resources.size() == 0 && dumps.size() == 0 && collections.size() == 0 && associations.size() == 0) continue;
                regMeta.setResources(resources.toArray(new String[resources.size()]));
                regMeta.setDumps(dumps.toArray(new String[dumps.size()]));
                regMeta.setCollections(collections.toArray(new String[collections.size()]));
                regMeta.setAssociations(associations.toArray(new Association[associations.size()]));
                regArtifacts.add(regMeta);
                continue;
            }
            if ("lib/registry/filter".equals(type)) {
                regFilterList.add(instanceName);
                continue;
            }
            if (!"lib/registry/handler".equals(type)) continue;
            regHandlerList.add(instanceName);
        }
        appData.setServiceGroups(serviceGroups.toArray(new ServiceGroupMetadata[serviceGroups.size()]));
        appData.setRegistryFilters(regFilterList.toArray(new String[regFilterList.size()]));
        appData.setRegistryHandlers(regHandlerList.toArray(new String[regHandlerList.size()]));
        appData.setRegistryArtifacts(regArtifacts.toArray(new RegistryMetadata[regArtifacts.size()]));
        return appData;
    }

    private AxisServiceGroup findServiceGroupForArtifact(Artifact artifact) {
        if (artifact.getFiles().size() != 1) {
            return null;
        }
        String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
        AxisConfiguration axisConfiguration = this.getAxisConfig();
        Iterator serviceGroups = axisConfiguration.getServiceGroups();
        while (serviceGroups.hasNext()) {
            String serviceType;
            String filePath;
            AxisServiceGroup sg = (AxisServiceGroup)serviceGroups.next();
            if (SystemFilter.isFilteredOutService((AxisServiceGroup)sg)) continue;
            AxisService axisService = null;
            Iterator services = sg.getServices();
            while (services.hasNext()) {
                AxisService temp = (AxisService)services.next();
                if (temp.getFileName() == null) continue;
                axisService = temp;
                break;
            }
            if (axisService == null || !(filePath = axisService.getFileName().getPath().trim()).endsWith(fileName) || !(serviceType = this.getArtifactTypeFromService(axisService, fileName)).equals(artifact.getType())) continue;
            return sg;
        }
        return null;
    }

    private String getArtifactTypeFromService(AxisService service, String fileName) {
        String artifactType = null;
        Parameter serviceTypeParam = service.getParameter("serviceType");
        String serviceType = serviceTypeParam != null ? (String)serviceTypeParam.getValue() : (fileName.endsWith(".jar") ? "jaxws" : "axis2");
        if (serviceType.equals("axis2")) {
            artifactType = "service/axis2";
        } else if (serviceType.equals("data_service")) {
            artifactType = "service/dataservice";
        }
        return artifactType;
    }

    private RegistryConfig readRegConfig(String parentAppName, String artifactName) {
        RegistryConfig regConfig = null;
        try {
            CarbonAppPersistenceManager capm = new CarbonAppPersistenceManager(this.getAxisConfig());
            regConfig = capm.loadRegistryConfig("repository/applications/" + parentAppName + "/dependencies/" + artifactName);
        }
        catch (Exception e) {
            log.error((Object)("Error while trying to load registry config for C-App : " + parentAppName + " artifact : " + artifactName), (Throwable)e);
        }
        return regConfig;
    }

    public DataHandler downloadCappArchive(String fileName) throws Exception {
        CarbonApplication currentApp = null;
        String tenantId = AppDeployerUtils.getTenantIdString((AxisConfiguration)this.getAxisConfig());
        ArrayList appList = AppManagementServiceComponent.getAppManager().getCarbonApps(tenantId);
        for (CarbonApplication carbonApp : appList) {
            if (!fileName.equals(carbonApp.getAppName())) continue;
            currentApp = carbonApp;
        }
        FileDataSource datasource = new FileDataSource(new File(currentApp.getAppFilePath()));
        DataHandler handler = new DataHandler((DataSource)datasource);
        return handler;
    }

    private void handleException(String msg) throws CarbonException {
        log.error((Object)msg);
        throw new CarbonException(msg);
    }
}

