/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.mgt.webapp.ui;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.application.mgt.webapp.stub.WarApplicationAdminStub;
import org.wso2.carbon.application.mgt.webapp.stub.types.carbon.WarCappMetadata;

public class WarAppAdminClient {
    private static final Log log = LogFactory.getLog(WarAppAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.application.mgt.webapp.ui.i18n.Resources";
    private ResourceBundle bundle;
    public WarApplicationAdminStub stub;

    public WarAppAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "WarApplicationAdmin";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new WarApplicationAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public WarCappMetadata[] getWarAppData(String appName) throws AxisFault {
        try {
            return this.stub.getWarAppData(appName);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.get.service.data"), e);
            return null;
        }
    }

    public WarCappMetadata[] getJaxWSWarAppData(String appName) throws AxisFault {
        try {
            return this.stub.getJaxWSWarAppData(appName);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.get.service.data"), e);
            return null;
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

