/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.mgt.webapp;

import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.deployer.config.CappFile;
import org.wso2.carbon.application.mgt.webapp.WarCappMetadata;
import org.wso2.carbon.application.mgt.webapp.internal.WarAppServiceComponent;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.NetworkUtils;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;

public class WarApplicationAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(WarApplicationAdmin.class);
    public static final String STARTED = "Started";
    public static final String STOPPED = "Stopped";
    public static final String FAULTY = "Faulty";

    public WarCappMetadata[] getWarAppData(String appName) throws Exception {
        String tenantId = AppDeployerUtils.getTenantIdString((AxisConfiguration)this.getAxisConfig());
        ArrayList appList = WarAppServiceComponent.getAppManager().getCarbonApps(tenantId);
        CarbonApplication currentApplication = null;
        for (CarbonApplication application : appList) {
            if (!appName.equals(application.getAppName())) continue;
            currentApplication = application;
            break;
        }
        if (currentApplication == null) {
            String msg = "No Carbon Application found of the name : " + appName;
            log.error((Object)msg);
            throw new Exception(msg);
        }
        List deps = currentApplication.getAppConfig().getApplicationArtifact().getDependencies();
        ArrayList<WarCappMetadata> webappList = new ArrayList<WarCappMetadata>();
        for (Artifact.Dependency dep : deps) {
            Artifact artifact = dep.getArtifact();
            if (!"web/application".equals(artifact.getType())) continue;
            webappList.add(this.getWebappMetadata(((CappFile)artifact.getFiles().get(0)).getName()));
        }
        return webappList.toArray(new WarCappMetadata[webappList.size()]);
    }

    private WarCappMetadata getWebappMetadata(String fileName) {
        WarCappMetadata warCappMetadata = null;
        WebApplicationsHolder holder = (WebApplicationsHolder)this.getConfigContext().getProperty("carbon.webapps.holder");
        String state = STARTED;
        WebApplication webApplication = (WebApplication)holder.getStartedWebapps().get(fileName);
        if (webApplication == null) {
            state = STOPPED;
            webApplication = (WebApplication)holder.getStoppedWebapps().get(fileName);
        }
        if (webApplication == null) {
            state = FAULTY;
            webApplication = (WebApplication)holder.getFaultyWebapps().get(fileName);
        }
        if (webApplication != null) {
            warCappMetadata = new WarCappMetadata();
            warCappMetadata.setContext(webApplication.getContextName());
            warCappMetadata.setState(state);
            warCappMetadata.setWebappFileName(webApplication.getWebappFile().getName());
            try {
                warCappMetadata.setHostName(NetworkUtils.getLocalHostname());
            }
            catch (SocketException e) {
                log.error((Object)"Error occurred while getting local hostname", (Throwable)e);
            }
            int httpPort = CarbonUtils.getTransportProxyPort((ConfigurationContext)this.getConfigContext(), (String)"http");
            if (httpPort == -1) {
                httpPort = CarbonUtils.getTransportPort((ConfigurationContext)this.getConfigContext(), (String)"http");
            }
            warCappMetadata.setHttpPort(httpPort);
        }
        return warCappMetadata;
    }

    public WarCappMetadata[] getJaxWSWarAppData(String appName) throws Exception {
        String tenantId = AppDeployerUtils.getTenantIdString((AxisConfiguration)this.getAxisConfig());
        ArrayList appList = WarAppServiceComponent.getAppManager().getCarbonApps(tenantId);
        CarbonApplication currentApplication = null;
        for (CarbonApplication application : appList) {
            if (!appName.equals(application.getAppName())) continue;
            currentApplication = application;
            break;
        }
        if (currentApplication == null) {
            String msg = "No Carbon Application found of the name : " + appName;
            log.error((Object)msg);
            throw new Exception(msg);
        }
        List deps = currentApplication.getAppConfig().getApplicationArtifact().getDependencies();
        ArrayList<WarCappMetadata> webappList = new ArrayList<WarCappMetadata>();
        for (Artifact.Dependency dep : deps) {
            Artifact artifact = dep.getArtifact();
            if (!"webapp/jaxws".equals(artifact.getType())) continue;
            webappList.add(this.getWebappMetadata(((CappFile)artifact.getFiles().get(0)).getName()));
        }
        return webappList.toArray(new WarCappMetadata[webappList.size()]);
    }
}

