/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.mgt.ui;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.activation.DataHandler;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.application.mgt.stub.ApplicationAdminExceptionException;
import org.wso2.carbon.application.mgt.stub.ApplicationAdminStub;
import org.wso2.carbon.application.mgt.stub.types.carbon.ApplicationMetadata;

public class ApplicationAdminClient {
    private static final Log log = LogFactory.getLog(ApplicationAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.application.mgt.ui.i18n.Resources";
    private ResourceBundle bundle;
    public ApplicationAdminStub stub;

    public ApplicationAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "ApplicationAdmin";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new ApplicationAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        option.setProperty("enableMTOM", (Object)"true");
    }

    public String[] getAllApps() throws AxisFault {
        try {
            return this.stub.listAllApplications();
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.get.service.data"), e);
            return null;
        }
    }

    public ApplicationMetadata getAppData(String appName) throws AxisFault {
        try {
            return this.stub.getAppData(appName);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.get.service.data"), e);
            return null;
        }
    }

    public void deleteApp(String appName) throws AxisFault {
        try {
            this.stub.deleteApplication(appName);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.delete.artifact"), e);
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    public void downloadCappArchive(String filename, HttpServletResponse response) throws IOException, ApplicationAdminExceptionException {
        ServletOutputStream out = response.getOutputStream();
        DataHandler dataHandler = this.stub.downloadCappArchive(filename);
        if (dataHandler != null) {
            int nextChar;
            response.setHeader("Content-Disposition", "fileName=" + filename + ".car");
            response.setContentType(dataHandler.getContentType());
            InputStream in = dataHandler.getDataSource().getInputStream();
            while ((nextChar = in.read()) != -1) {
                out.write((int)((char)nextChar));
            }
            out.flush();
            in.close();
            out.close();
        } else {
            out.write("The requested capp archive was not found on the server".getBytes());
        }
    }
}

