/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.mgt.synapse.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.application.deployer.service.ApplicationManagerService;
import org.wso2.carbon.mediation.initializer.services.SynapseConfigurationService;
import org.wso2.carbon.registry.core.service.RegistryService;

public class SynapseAppServiceComponent {
    private static Log log = LogFactory.getLog(SynapseAppServiceComponent.class);
    private static RegistryService registryServiceInstance;
    private static SynapseConfigurationService scService;
    private static ApplicationManagerService applicationManager;

    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Activated SynapseAppServiceComponent");
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deactivated SynapseAppServiceComponent");
        }
    }

    protected void setRegistryService(RegistryService registryService) {
        registryServiceInstance = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        registryServiceInstance = null;
    }

    protected void setSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        scService = synapseConfigurationService;
    }

    protected void unsetSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        scService = null;
    }

    protected void setAppManager(ApplicationManagerService appManager) {
        applicationManager = appManager;
    }

    protected void unsetAppManager(ApplicationManagerService appManager) {
        applicationManager = null;
    }

    public static ApplicationManagerService getAppManager() throws Exception {
        if (applicationManager == null) {
            String msg = "Before activating Synapse App management service bundle, an instance of ApplicationManager should be in existance";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        return applicationManager;
    }

    public static RegistryService getRegistryService() throws Exception {
        if (registryServiceInstance == null) {
            String msg = "Before activating Synapse App management service bundle, an instance of RegistryService should be in existance";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        return registryServiceInstance;
    }

    public static SynapseConfigurationService getScService() throws Exception {
        if (scService == null) {
            String msg = "Before activating Synapse App management service bundle, an instance of SynapseConfigurationService should be in existance";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        return scService;
    }
}

