/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.mgt.synapse;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Startup;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.DefaultEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.FailoverEndpoint;
import org.apache.synapse.endpoints.LoadbalanceEndpoint;
import org.apache.synapse.endpoints.WSDLEndpoint;
import org.apache.synapse.startup.quartz.SimpleQuartz;
import org.apache.synapse.task.TaskDescription;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.mgt.synapse.EndpointMetadata;
import org.wso2.carbon.application.mgt.synapse.SynapseApplicationMetadata;
import org.wso2.carbon.application.mgt.synapse.TaskMetadata;
import org.wso2.carbon.application.mgt.synapse.internal.SynapseAppServiceComponent;
import org.wso2.carbon.core.AbstractAdmin;

public class SynapseApplicationAdmin
extends AbstractAdmin {
    public static final String ADDRESS_EP = "address";
    public static final String FAILOVER_EP = "failOver";
    public static final String WSDL_EP = "WSDL";
    public static final String LOADBALANCE_EP = "loadBalance";
    public static final String DEFAULT_EP = "default";
    private static final Log log = LogFactory.getLog(SynapseApplicationAdmin.class);

    public SynapseApplicationMetadata getSynapseAppData(String appName) throws Exception {
        SynapseApplicationMetadata data = new SynapseApplicationMetadata();
        String tenantId = AppDeployerUtils.getTenantIdString((AxisConfiguration)this.getAxisConfig());
        ArrayList appList = SynapseAppServiceComponent.getAppManager().getCarbonApps(tenantId);
        CarbonApplication currentApplication = null;
        for (CarbonApplication application : appList) {
            if (!appName.equals(application.getAppName())) continue;
            data.setAppName(appName);
            currentApplication = application;
            break;
        }
        if (currentApplication == null) {
            String msg = "No Carbon Application found of the name : " + appName;
            log.error((Object)msg);
            throw new Exception(msg);
        }
        ArrayList<String> sequenceList = new ArrayList<String>();
        ArrayList<EndpointMetadata> endpointList = new ArrayList<EndpointMetadata>();
        ArrayList<String> proxyList = new ArrayList<String>();
        ArrayList<String> leList = new ArrayList<String>();
        ArrayList<String> eventList = new ArrayList<String>();
        ArrayList<String> mediatorList = new ArrayList<String>();
        ArrayList<TaskMetadata> taskList = new ArrayList<TaskMetadata>();
        List dependencies = currentApplication.getAppConfig().getApplicationArtifact().getDependencies();
        for (Artifact.Dependency dependency : dependencies) {
            Artifact artifact = dependency.getArtifact();
            String type = artifact.getType();
            String instanceName = artifact.getRuntimeObjectName();
            if (instanceName == null) continue;
            if ("synapse/sequence".equals(type)) {
                sequenceList.add(instanceName);
                continue;
            }
            if ("synapse/endpoint".equals(type)) {
                Endpoint endpoint = SynapseAppServiceComponent.getScService().getSynapseConfiguration().getEndpoint(instanceName);
                if (endpoint == null) continue;
                EndpointMetadata epData = new EndpointMetadata();
                epData.setName(instanceName);
                epData.setType(this.getEndpointType(endpoint));
                endpointList.add(epData);
                continue;
            }
            if ("synapse/proxy-service".equals(type)) {
                proxyList.add(instanceName);
                continue;
            }
            if ("synapse/local-entry".equals(type)) {
                leList.add(instanceName);
                continue;
            }
            if ("synapse/event-source".equals(type)) {
                eventList.add(instanceName);
                continue;
            }
            if ("lib/synapse/mediator".equals(type)) {
                mediatorList.add(instanceName);
                continue;
            }
            if (!"synapse/task".equals(type)) continue;
            Startup task = SynapseAppServiceComponent.getScService().getSynapseConfiguration().getStartup(instanceName);
            TaskDescription taskDescription = ((SimpleQuartz)task).getTaskDescription();
            TaskMetadata taskMetadata = new TaskMetadata();
            taskMetadata.setName(taskDescription.getName());
            taskMetadata.setGroupName(taskDescription.getGroup());
            taskList.add(taskMetadata);
        }
        data.setSequences(sequenceList.toArray(new String[sequenceList.size()]));
        data.setEndpoints(endpointList.toArray(new EndpointMetadata[endpointList.size()]));
        data.setProxyServices(proxyList.toArray(new String[proxyList.size()]));
        data.setLocalEntries(leList.toArray(new String[leList.size()]));
        data.setEvents(eventList.toArray(new String[eventList.size()]));
        data.setMediators(mediatorList.toArray(new String[mediatorList.size()]));
        data.setTasks(taskList.toArray(new TaskMetadata[taskList.size()]));
        return data;
    }

    private String getEndpointType(Endpoint ep) {
        String epType = null;
        if (ep instanceof AddressEndpoint) {
            epType = ADDRESS_EP;
        } else if (ep instanceof DefaultEndpoint) {
            epType = DEFAULT_EP;
        } else if (ep instanceof WSDLEndpoint) {
            epType = WSDL_EP;
        } else if (ep instanceof FailoverEndpoint) {
            epType = FAILOVER_EP;
        } else if (ep instanceof LoadbalanceEndpoint) {
            epType = LOADBALANCE_EP;
        }
        return epType;
    }
}

