/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.mgt.bpel;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.mgt.bpel.BPELAppMetadata;
import org.wso2.carbon.application.mgt.bpel.PackageMetadata;
import org.wso2.carbon.application.mgt.bpel.internal.BPELAppMgtServiceComponent;
import org.wso2.carbon.bpel.core.ode.integration.mgt.services.BPELPackageManagementServiceSkeleton;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.LimitedProcessInfoType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.PackageType;
import org.wso2.carbon.bpel.skeleton.ode.integration.mgt.services.types.Version_type0;
import org.wso2.carbon.core.AbstractAdmin;

public class BPELApplicationAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(BPELApplicationAdmin.class);

    public BPELAppMetadata getBPELAppData(String appName) throws Exception {
        BPELAppMetadata data = new BPELAppMetadata();
        String tenantId = AppDeployerUtils.getTenantIdString((AxisConfiguration)this.getAxisConfig());
        ArrayList appList = BPELAppMgtServiceComponent.getAppManager().getCarbonApps(tenantId);
        CarbonApplication currentApplication = null;
        for (CarbonApplication application : appList) {
            if (!appName.equals(application.getAppName())) continue;
            currentApplication = application;
            break;
        }
        if (currentApplication == null) {
            String msg = "No Carbon Application found of the name : " + appName;
            log.error((Object)msg);
            throw new Exception(msg);
        }
        List deps = currentApplication.getAppConfig().getApplicationArtifact().getDependencies();
        BPELPackageManagementServiceSkeleton bpelAdmin = new BPELPackageManagementServiceSkeleton();
        ArrayList<PackageMetadata> packageList = new ArrayList<PackageMetadata>();
        for (Artifact.Dependency dep : deps) {
            Artifact artifact = dep.getArtifact();
            String packageName = artifact.getRuntimeObjectName();
            if (packageName == null || !"bpel/workflow".equals(artifact.getType())) continue;
            PackageMetadata packageMetadata = new PackageMetadata();
            packageMetadata.setPackageName(packageName);
            ArrayList<String> processList = new ArrayList<String>();
            PackageType packageType = bpelAdmin.listProcessesInPackage(packageName);
            for (Version_type0 packageVersion : packageType.getVersions().getVersion()) {
                if (!packageVersion.getName().equals(packageName)) continue;
                for (LimitedProcessInfoType process : packageVersion.getProcesses().getProcess()) {
                    processList.add(process.getPid());
                }
            }
            String[] processes = new String[processList.size()];
            packageMetadata.setProcessList(processes);
            packageList.add(packageMetadata);
        }
        data.setPackages(packageList.toArray(new PackageMetadata[packageList.size()]));
        return data;
    }
}

