/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer.webapp;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.deployer.config.CappFile;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.application.deployer.webapp.internal.WARCappDeployerDSComponent;
import org.wso2.carbon.jaxws.webapp.mgt.JaxwsWebappAdmin;
import org.wso2.carbon.webapp.mgt.WebappAdmin;

public class WARCappDeployer
implements AppDeploymentHandler {
    private static final Log log = LogFactory.getLog(WARCappDeployer.class);
    public static final String WAR_TYPE = "web/application";
    public static final String JAX_WAR_TYPE = "webapp/jaxws";
    public static final String WAR_DIR = "webapps";
    public static final String JAX_WAR_DIR = "jaxwebapps";
    private Map<String, Boolean> acceptanceList = null;

    public void deployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) {
        List artifacts = carbonApp.getAppConfig().getApplicationArtifact().getDependencies();
        String repo = axisConfig.getRepository().getPath();
        for (Artifact.Dependency dep : artifacts) {
            String destPath;
            Artifact artifact = dep.getArtifact();
            if (artifact == null) continue;
            if (!this.isAccepted(artifact.getType())) {
                log.warn((Object)("Can't deploy artifact : " + artifact.getName() + " of type : " + artifact.getType() + ". Required features are not installed in the system"));
                continue;
            }
            if (WAR_TYPE.equals(artifact.getType())) {
                destPath = repo + File.separator + WAR_DIR;
            } else {
                if (!JAX_WAR_TYPE.equals(artifact.getType())) continue;
                destPath = repo + File.separator + JAX_WAR_DIR;
            }
            List files = artifact.getFiles();
            if (files.size() != 1) {
                log.error((Object)("Web Applications must have a single WAR file to be deployed. But " + files.size() + " files found."));
                continue;
            }
            String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
            String artifactPath = artifact.getExtractedPath() + File.separator + fileName;
            AppDeployerUtils.createDir((String)destPath);
            AppDeployerUtils.copyFile((String)artifactPath, (String)(destPath + File.separator + fileName));
        }
    }

    public void undeployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) {
        List artifacts = carbonApp.getAppConfig().getApplicationArtifact().getDependencies();
        for (Artifact.Dependency dep : artifacts) {
            Artifact artifact = dep.getArtifact();
            if (artifact == null || !WAR_TYPE.equals(artifact.getType()) && !JAX_WAR_TYPE.equals(artifact.getType())) continue;
            List files = artifact.getFiles();
            if (files.size() != 1) {
                log.error((Object)("Web Applications must have a single WAR file. But " + files.size() + " files found."));
                continue;
            }
            String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
            if (JAX_WAR_TYPE.equals(artifact.getType())) {
                JaxwsWebappAdmin jaxwsWebappAdmin = new JaxwsWebappAdmin();
                try {
                    jaxwsWebappAdmin.deleteWebapp(fileName);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)("Error while deleting webapp artifact " + fileName), (Throwable)axisFault);
                }
                continue;
            }
            WebappAdmin webappAdmin = new WebappAdmin();
            try {
                webappAdmin.deleteWebapp(fileName);
            }
            catch (AxisFault axisFault) {
                log.error((Object)("Error while deleting webapp artifact " + fileName), (Throwable)axisFault);
            }
        }
    }

    private boolean isAccepted(String serviceType) {
        Boolean acceptance;
        if (this.acceptanceList == null) {
            this.acceptanceList = AppDeployerUtils.buildAcceptanceList(WARCappDeployerDSComponent.getRequiredFeatures());
        }
        return (acceptance = this.acceptanceList.get(serviceType)) == null || acceptance != false;
    }
}

