/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer.synapse;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.deployer.config.CappFile;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.application.deployer.synapse.internal.SynapseAppDeployerDSComponent;

public class SynapseAppDeployer
implements AppDeploymentHandler {
    private static final Log log = LogFactory.getLog(SynapseAppDeployer.class);
    private Map<String, Boolean> acceptanceList = null;

    public void deployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) {
        List artifacts = carbonApp.getAppConfig().getApplicationArtifact().getDependencies();
        String synapseRepo = axisConfig.getRepository().getPath() + File.separator + "synapse-configs" + File.separator + "default";
        for (Artifact.Dependency dep : artifacts) {
            String destPath;
            Artifact artifact = dep.getArtifact();
            if (artifact == null) continue;
            if (!this.isAccepted(artifact.getType())) {
                log.warn((Object)("Can't deploy artifact : " + artifact.getName() + " of type : " + artifact.getType() + ". Required features are not installed in the system"));
                continue;
            }
            if ("synapse/sequence".equals(artifact.getType())) {
                destPath = synapseRepo + "/sequences/";
            } else if ("synapse/endpoint".equals(artifact.getType())) {
                destPath = synapseRepo + "/endpoints/";
            } else if ("synapse/proxy-service".equals(artifact.getType())) {
                destPath = synapseRepo + "/proxy-services/";
            } else if ("synapse/local-entry".equals(artifact.getType())) {
                destPath = synapseRepo + "/local-entries/";
            } else if ("synapse/event-source".equals(artifact.getType())) {
                destPath = synapseRepo + "/event-sources/";
            } else if ("synapse/task".equals(artifact.getType())) {
                destPath = synapseRepo + "/tasks/";
            } else if ("synapse/message-store".endsWith(artifact.getType())) {
                destPath = synapseRepo + "/message-store/";
            } else {
                if (!"synapse/message-processors".endsWith(artifact.getType())) continue;
                destPath = synapseRepo + "/message-processors/";
            }
            List files = artifact.getFiles();
            if (files.size() != 1) {
                log.error((Object)("Synapse artifact types must have a single file to be deployed. But " + files.size() + " files found."));
                continue;
            }
            String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
            String artifactPath = artifact.getExtractedPath() + File.separator + fileName;
            AppDeployerUtils.createDir((String)destPath);
            AppDeployerUtils.copyFile((String)artifactPath, (String)(destPath + File.separator + fileName));
        }
    }

    public void undeployArtifacts(CarbonApplication carbonApplication, AxisConfiguration axisConfig) {
        List artifacts = carbonApplication.getAppConfig().getApplicationArtifact().getDependencies();
        String synapseRepo = axisConfig.getRepository().getPath() + File.separator + "synapse-configs" + File.separator + "default";
        for (Artifact.Dependency dep : artifacts) {
            String destPath;
            Artifact artifact = dep.getArtifact();
            if (artifact == null) continue;
            if ("synapse/sequence".equals(artifact.getType())) {
                destPath = synapseRepo + "/sequences/";
            } else if ("synapse/endpoint".equals(artifact.getType())) {
                destPath = synapseRepo + "/endpoints/";
            } else if ("synapse/proxy-service".equals(artifact.getType())) {
                destPath = synapseRepo + "/proxy-services/";
            } else if ("synapse/local-entry".equals(artifact.getType())) {
                destPath = synapseRepo + "/local-entries/";
            } else if ("synapse/event-source".equals(artifact.getType())) {
                destPath = synapseRepo + "/event-sources/";
            } else if ("synapse/task".equals(artifact.getType())) {
                destPath = synapseRepo + "/tasks/";
            } else if ("synapse/message-store".equals(artifact.getType())) {
                destPath = synapseRepo + "/message-store/";
            } else {
                if (!"synapse/message-processors".equals(artifact.getType())) continue;
                destPath = synapseRepo + "/message-processors/";
            }
            List files = artifact.getFiles();
            if (files.size() != 1) {
                log.error((Object)("Synapse artifact types must have a single file. But " + files.size() + " files found."));
                continue;
            }
            String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
            String artifactPath = destPath + File.separator + fileName;
            File artifactFile = new File(artifactPath);
            if (!artifactFile.exists() || artifactFile.delete()) continue;
            log.warn((Object)("Couldn't delete App artifact file : " + artifactPath));
        }
    }

    private boolean isAccepted(String serviceType) {
        Boolean acceptance;
        if (this.acceptanceList == null) {
            this.acceptanceList = AppDeployerUtils.buildAcceptanceList(SynapseAppDeployerDSComponent.getRequiredFeatures());
        }
        return (acceptance = this.acceptanceList.get(serviceType)) == null || acceptance != false;
    }
}

