/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer.brs;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.brs.internal.BRSAppDeployerDSComponent;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.deployer.config.CappFile;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.utils.ArchiveManipulator;
import org.wso2.carbon.utils.FileManipulator;

public class BRSAppDeployer
implements AppDeploymentHandler {
    private static final Log log = LogFactory.getLog(BRSAppDeployer.class);
    public static final String BRS_TYPE = "service/rule";
    public static final String BRS_DIR = "ruleservices";
    private Map<String, Boolean> acceptanceList = null;

    public void deployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) {
        List artifacts = carbonApp.getAppConfig().getApplicationArtifact().getDependencies();
        String repo = axisConfig.getRepository().getPath();
        for (Artifact.Dependency dep : artifacts) {
            Artifact artifact = dep.getArtifact();
            if (artifact == null) continue;
            String artifactName = artifact.getName();
            if (!this.isAccepted(artifact.getType())) {
                log.warn((Object)("Can't deploy artifact : " + artifactName + " of type : " + artifact.getType() + ". Required features are not installed in the system"));
                continue;
            }
            if (!BRS_TYPE.equals(artifact.getType())) continue;
            String destPath = repo + BRS_DIR;
            List files = artifact.getFiles();
            if (files.size() != 1) {
                log.error((Object)("BRS must have a single file to be deployed. But " + files.size() + " files found."));
                continue;
            }
            String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
            String artifactPath = artifact.getExtractedPath() + File.separator + fileName;
            try {
                FileManipulator.copyFileToDir((File)new File(artifactPath), (File)new File(destPath));
            }
            catch (IOException e) {
                log.error((Object)("Unable to copy the BRS : " + artifactName), (Throwable)e);
            }
        }
    }

    public void undeployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) {
        List artifacts = carbonApp.getAppConfig().getApplicationArtifact().getDependencies();
        ArchiveManipulator archiveManipulator = new ArchiveManipulator();
        String repo = axisConfig.getRepository().getPath();
        for (Artifact.Dependency dep : artifacts) {
            Artifact artifact = dep.getArtifact();
            if (artifact == null || !BRS_TYPE.equals(artifact.getType())) continue;
            String destPath = repo + File.separator + BRS_DIR;
            List files = artifact.getFiles();
            if (files.size() != 1) {
                log.error((Object)("A BRS must have a single file. But " + files.size() + " files found."));
                continue;
            }
            String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
            String artifactPath = artifact.getExtractedPath() + File.separator + fileName;
            try {
                String[] filesInZip = archiveManipulator.check(artifactPath);
                File jsFile = null;
                for (String file : filesInZip) {
                    String artifactRepoPath = destPath + File.separator + file;
                    if (file.indexOf("/") != -1) continue;
                    String extension = file.substring(file.indexOf(".") + 1);
                    if ("js".equals(extension)) {
                        jsFile = new File(destPath + File.separator + file);
                        continue;
                    }
                    File artifactInRepo = new File(artifactRepoPath);
                    if (!artifactInRepo.exists() || !artifactInRepo.delete()) continue;
                    log.warn((Object)("Couldn't delete BRS artifact file : " + artifactPath));
                }
                if (jsFile == null || !jsFile.exists() || jsFile.delete()) continue;
                log.warn((Object)("Couldn't delete BRS artifact file : " + artifactPath));
            }
            catch (IOException e) {
                log.error((Object)("Error reading the content of the artifact : " + artifact.getName()), (Throwable)e);
            }
        }
    }

    private boolean isAccepted(String serviceType) {
        Boolean acceptance;
        if (this.acceptanceList == null) {
            this.acceptanceList = AppDeployerUtils.buildAcceptanceList(BRSAppDeployerDSComponent.getRequiredFeatures());
        }
        return (acceptance = this.acceptanceList.get(serviceType)) == null || acceptance != false;
    }
}

