/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer.brs.internal;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.Feature;
import org.wso2.carbon.application.deployer.brs.BRSAppDeployer;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;

public class BRSAppDeployerDSComponent {
    private static Log log = LogFactory.getLog(BRSAppDeployerDSComponent.class);
    private static Map<String, List<Feature>> requiredFeatures;
    private static ServiceRegistration appHandlerRegistration;

    protected void activate(ComponentContext ctxt) {
        try {
            BRSAppDeployer brsDeployer = new BRSAppDeployer();
            appHandlerRegistration = ctxt.getBundleContext().registerService(AppDeploymentHandler.class.getName(), (Object)brsDeployer, null);
            URL reqFeaturesResource = ctxt.getBundleContext().getBundle().getResource("required-features.xml");
            if (reqFeaturesResource != null) {
                InputStream xmlStream = reqFeaturesResource.openStream();
                requiredFeatures = AppDeployerUtils.readRequiredFeaturs((OMElement)new StAXOMBuilder(xmlStream).getDocumentElement());
            }
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate BRS Application Deployer", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        if (appHandlerRegistration != null) {
            appHandlerRegistration.unregister();
        }
    }

    public static Map<String, List<Feature>> getRequiredFeatures() {
        return requiredFeatures;
    }
}

