/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer.bpel;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.bpel.internal.BPELAppDeployerDSComponent;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.deployer.config.CappFile;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;

public class BPELAppDeployer
implements AppDeploymentHandler {
    private static final Log log = LogFactory.getLog(BPELAppDeployer.class);
    public static final String BPEL_TYPE = "bpel/workflow";
    public static final String BPEL_DIR = "bpel";
    private Map<String, Boolean> acceptanceList = null;

    public void deployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) {
        List artifacts = carbonApp.getAppConfig().getApplicationArtifact().getDependencies();
        String repo = axisConfig.getRepository().getPath();
        for (Artifact.Dependency dep : artifacts) {
            Artifact artifact = dep.getArtifact();
            if (artifact == null) continue;
            if (!this.isAccepted(artifact.getType())) {
                log.warn((Object)("Can't deploy artifact : " + artifact.getName() + " of type : " + artifact.getType() + ". Required features are not installed in the system"));
                continue;
            }
            if (!BPEL_TYPE.equals(artifact.getType())) continue;
            String destPath = repo + File.separator + BPEL_DIR;
            List files = artifact.getFiles();
            if (files.size() != 1) {
                log.error((Object)("BPEL workflows must have a single file to be deployed. But " + files.size() + " files found."));
                continue;
            }
            String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
            String artifactPath = artifact.getExtractedPath() + File.separator + fileName;
            AppDeployerUtils.createDir((String)destPath);
            AppDeployerUtils.copyFile((String)artifactPath, (String)(destPath + File.separator + fileName));
        }
    }

    public void undeployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) {
        List artifacts = carbonApp.getAppConfig().getApplicationArtifact().getDependencies();
        String repo = axisConfig.getRepository().getPath();
        for (Artifact.Dependency dep : artifacts) {
            Artifact artifact = dep.getArtifact();
            if (artifact == null || !BPEL_TYPE.equals(artifact.getType())) continue;
            String destPath = repo + File.separator + BPEL_DIR;
            List files = artifact.getFiles();
            if (files.size() != 1) {
                log.error((Object)("A BPEL workflow must have a single file. But " + files.size() + " files found."));
                continue;
            }
            String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
            String artifactPath = destPath + File.separator + fileName;
            File artifactFile = new File(artifactPath);
            if (!artifactFile.exists() || artifactFile.delete()) continue;
            log.warn((Object)("Couldn't delete App artifact file : " + artifactPath));
        }
    }

    private boolean isAccepted(String serviceType) {
        Boolean acceptance;
        if (this.acceptanceList == null) {
            this.acceptanceList = AppDeployerUtils.buildAcceptanceList(BPELAppDeployerDSComponent.getRequiredFeatures());
        }
        return (acceptance = this.acceptanceList.get(serviceType)) == null || acceptance != false;
    }
}

