/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.application.deployment.service.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.wso2.carbon.appfactory.application.deployment.service.ApplicationDeploymentExceptions;
import org.xml.sax.SAXException;

public class WebXMLParametersUpdater {
    private static final Log log = LogFactory.getLog(WebXMLParametersUpdater.class);
    public static final String DB_URL = "databaseUrl";
    public static final String DB_USERNAME = "databaseUsername";
    public static final String DB_PASSWORD = "databasePassword";

    public boolean updateParameters(String rootDir, Map<String, String> parameters) throws ApplicationDeploymentExceptions {
        File carProjectFiles = new File(rootDir);
        if (carProjectFiles != null && carProjectFiles.isDirectory()) {
            for (File artifact : carProjectFiles.listFiles()) {
                if (!artifact.isDirectory()) continue;
                File pom = new File(artifact + File.separator + "pom.xml");
                if (pom.exists()) {
                    if (!this.isWebApp(pom)) continue;
                    this.updateWebXML(artifact, parameters);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("no pom.xml file in " + artifact.getName()));
            }
            return true;
        }
        log.error((Object)("There are no project file in the directory " + carProjectFiles));
        return false;
    }

    private void updateWebXML(File artifact, Map<String, String> parameters) throws ApplicationDeploymentExceptions {
        NodeList contextParams;
        File webXML = new File(artifact + File.separator + "src" + File.separator + "main" + File.separator + "webapp" + File.separator + "WEB-INF" + File.separator + "web.xml");
        Document document = this.getDocument(webXML);
        XPathExpression contextValue = this.compile("//context-param");
        try {
            contextParams = (NodeList)contextValue.evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            String msg = "Error occurred during xpath expression evaluation " + contextValue.toString();
            log.error((Object)msg, (Throwable)e);
            throw new ApplicationDeploymentExceptions(msg, e);
        }
        if (contextParams.getLength() > 0) {
            for (int i = 0; i < contextParams.getLength(); ++i) {
                String name = contextParams.item(i).getChildNodes().item(1).getChildNodes().item(0).getNodeValue();
                String value = contextParams.item(i).getChildNodes().item(3).getChildNodes().item(0).getNodeValue();
                System.out.println("name :" + name + "val :" + value);
                if (DB_URL.equals(name)) {
                    value = value.replace("${databaseUrl}", parameters.get(DB_URL));
                    System.out.println("replacing db url..");
                } else if (parameters.get(name) != null) {
                    value = parameters.get(name);
                    System.out.println("replacing " + name);
                }
                contextParams.item(i).getChildNodes().item(3).getChildNodes().item(0).setNodeValue(value);
            }
            this.saveBack(document, webXML);
        }
    }

    private XPathExpression compile(String s) throws ApplicationDeploymentExceptions {
        XPathExpression expression;
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            expression = xPath.compile(s);
        }
        catch (XPathExpressionException e) {
            String msg = "Error occurred during xpath expression compilation " + s;
            log.error((Object)msg, (Throwable)e);
            throw new ApplicationDeploymentExceptions(msg, e);
        }
        return expression;
    }

    private void saveBack(Document document, File webXML) throws ApplicationDeploymentExceptions {
        DOMSource source = new DOMSource(document);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            FileWriter writer = new FileWriter(webXML);
            StreamResult streamResult = new StreamResult(writer);
            transformer.transform(source, streamResult);
        }
        catch (TransformerConfigurationException e) {
            String msg = "Error occurred during initialization of transformer";
            log.error((Object)msg, (Throwable)e);
            throw new ApplicationDeploymentExceptions(msg, e);
        }
        catch (TransformerException e) {
            String msg = "Error occurred during saving the web.xml back";
            log.error((Object)msg, (Throwable)e);
            throw new ApplicationDeploymentExceptions(msg, e);
        }
        catch (IOException e) {
            String msg = "Error occurred in opening file web.xml";
            log.error((Object)msg, (Throwable)e);
            throw new ApplicationDeploymentExceptions(msg, e);
        }
    }

    private boolean isWebApp(File pom) throws ApplicationDeploymentExceptions {
        Document document = this.getDocument(pom);
        XPathExpression expression = null;
        try {
            expression = this.compile("//packaging/text()");
            Object result = expression.evaluate(document, XPathConstants.NODESET);
            NodeList list = (NodeList)result;
            System.out.println("nodes " + list.item(0).getNodeValue());
            if (list.getLength() > 0) {
                return "war".equals(list.item(0).getNodeValue());
            }
        }
        catch (XPathExpressionException e) {
            String msg = "Error occurred during evaluation of xpath expression " + expression;
            log.error((Object)msg, (Throwable)e);
            throw new ApplicationDeploymentExceptions(msg, e);
        }
        return false;
    }

    private Document getDocument(File file) throws ApplicationDeploymentExceptions {
        Document doc;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        try {
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            doc = builder.parse(file);
        }
        catch (ParserConfigurationException e1) {
            String msg = "Error occurred during initialization of Document builder";
            log.error((Object)msg, (Throwable)e1);
            throw new ApplicationDeploymentExceptions(msg, e1);
        }
        catch (SAXException e1) {
            String msg = "Error occurred during parsing the file " + file;
            log.error((Object)msg, (Throwable)e1);
            throw new ApplicationDeploymentExceptions(msg, e1);
        }
        catch (IOException e1) {
            String msg = "Error occurred during reading the file " + file;
            log.error((Object)msg, (Throwable)e1);
            throw new ApplicationDeploymentExceptions(msg, e1);
        }
        return doc;
    }
}

