/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.application.deployment.service;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.SystemOutHandler;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapter;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.svnkit.SvnKitClientAdapterFactory;
import org.wso2.carbon.appfactory.application.deployment.service.Application;
import org.wso2.carbon.appfactory.application.deployment.service.ApplicationDeploymentExceptions;
import org.wso2.carbon.appfactory.application.deployment.service.internal.AppFactoryConfigurationHolder;
import org.wso2.carbon.appfactory.application.deployment.service.internal.ApplicationUploadClient;
import org.wso2.carbon.appfactory.application.deployment.service.internal.WebXMLParametersUpdater;
import org.wso2.carbon.appfactory.common.AppFactoryConfiguration;
import org.wso2.carbon.application.mgt.stub.upload.types.carbon.UploadedFileItem;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.utils.CarbonUtils;

public class ApplicationDeploymentService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(ApplicationDeploymentService.class);
    private static AppFactoryConfiguration appFactoryConfiguration = AppFactoryConfigurationHolder.getInstance().getAppFactoryConfiguration();
    private ISVNClientAdapter svnClient;

    private void initSVNClient() throws ApplicationDeploymentExceptions {
        try {
            SvnKitClientAdapterFactory.setup();
            log.debug((Object)"SVN Kit client adapter initialized");
        }
        catch (Throwable t) {
            log.debug((Object)"Unable to initialize the SVN Kit client adapter - Required jars may be missing", t);
        }
        try {
            JhlClientAdapterFactory.setup();
            log.debug((Object)"Java HL client adapter initialized");
        }
        catch (Throwable t) {
            log.debug((Object)"Unable to initialize the Java HL client adapter - Required jars  or the native libraries may be missing", t);
        }
        try {
            CmdLineClientAdapterFactory.setup();
            log.debug((Object)"Command line client adapter initialized");
        }
        catch (Throwable t) {
            log.debug((Object)"Unable to initialize the command line client adapter - SVN command line tools may be missing", t);
        }
        try {
            String clientType = SVNClientAdapterFactory.getPreferredSVNClientType();
            this.svnClient = SVNClientAdapterFactory.createSVNClient((String)clientType);
            this.svnClient.setUsername(appFactoryConfiguration.getFirstProperty("RepositoryMGTConfig.SCMServerAdminUserName"));
            this.svnClient.setPassword(appFactoryConfiguration.getFirstProperty("RepositoryMGTConfig.SCMServerAdminPassword"));
        }
        catch (SVNClientException e) {
            throw new ApplicationDeploymentExceptions("Client type can not be defined.");
        }
        if (this.svnClient == null) {
            throw new ApplicationDeploymentExceptions("Failed to instantiate svn client.");
        }
    }

    private String checkoutApplication(String applicationSvnUrl, String applicationId, String svnRevision) throws ApplicationDeploymentExceptions {
        File checkoutDirectory;
        block8: {
            checkoutDirectory = this.createApplicationCheckoutDirectory(applicationId);
            this.initSVNClient();
            SVNUrl svnUrl = null;
            try {
                svnUrl = new SVNUrl(applicationSvnUrl);
            }
            catch (MalformedURLException e) {
                this.handleException("SVN URL of application is malformed.", e);
            }
            try {
                if (svnRevision != null && !"".equals(svnRevision)) {
                    SVNRevision revision = SVNRevision.getRevision((String)svnRevision);
                    if (this.svnClient instanceof CmdLineClientAdapter) {
                        this.svnClient.checkout(svnUrl, checkoutDirectory, revision, true);
                    } else {
                        this.svnClient.checkout(svnUrl, checkoutDirectory, revision, 3, true, true);
                    }
                    break block8;
                }
                throw new ApplicationDeploymentExceptions("SVN revision number is null or empty");
            }
            catch (SVNClientException e) {
                this.handleException("Failed to checkout code from SVN URL:" + svnUrl, (Exception)((Object)e));
            }
            catch (ParseException e) {
                this.handleException("SVN revision: " + svnRevision + " is not valid ", e);
            }
        }
        return checkoutDirectory.getAbsolutePath();
    }

    private void buildApplication(String sourcePath) throws ApplicationDeploymentExceptions {
        String pomFilePath = sourcePath + File.separator + "pom.xml";
        File pomFile = new File(pomFilePath);
        if (!pomFile.exists()) {
            this.handleException("pom.xml file not found at " + pomFilePath);
        }
        this.executeMavenGoal(sourcePath);
        String targetDirPath = sourcePath + File.separator + "target";
        File targetDir = new File(targetDirPath);
        if (!targetDir.exists()) {
            this.handleException("Application build failure.");
        }
    }

    private File createApplicationCheckoutDirectory(String applicationName) throws ApplicationDeploymentExceptions {
        boolean directoriesCreated;
        File tempDir = new File(CarbonUtils.getTmpDir() + File.separator + applicationName);
        if (!tempDir.exists() && !(directoriesCreated = tempDir.mkdirs())) {
            this.handleException("Failed to create directory path:" + tempDir.getAbsolutePath());
        }
        return tempDir;
    }

    private void handleException(String msg) throws ApplicationDeploymentExceptions {
        log.error((Object)msg);
        throw new ApplicationDeploymentExceptions(msg);
    }

    private void handleException(String msg, Exception e) throws ApplicationDeploymentExceptions {
        log.error((Object)msg, (Throwable)e);
        throw new ApplicationDeploymentExceptions(msg, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Application[] deployApplication(String applicationSvnUrl, String applicationId, String stage, String version, String svnRevision) throws ApplicationDeploymentExceptions {
        String key = "ApplicationDeployment.DeploymentStage" + "." + stage + "." + "DeploymentServerURL";
        String[] deploymentServerUrls = appFactoryConfiguration.getProperties(key);
        if (deploymentServerUrls.length == 0) {
            this.handleException("No deployment paths are configured for stage:" + stage);
        }
        String checkoutPath = this.checkoutApplication(applicationSvnUrl, applicationId, svnRevision);
        new WebXMLParametersUpdater().updateParameters(checkoutPath, this.getDBParameters(stage));
        try {
            this.buildApplication(checkoutPath);
            File targetArtifacts = new File(checkoutPath + File.separator + "target");
            String[] fileExtension = new String[]{"car"};
            List artifactFiles = (List)FileUtils.listFiles((File)targetArtifacts, (String[])fileExtension, (boolean)false);
            ArrayList<Application> applications = new ArrayList<Application>();
            for (File deployArtifact : artifactFiles) {
                applications.add(new Application(deployArtifact.getName(), FileUtils.sizeOf((File)deployArtifact)));
                for (String deploymentServerUrl : deploymentServerUrls) {
                    this.uploadArtifact(applicationId, deployArtifact, deploymentServerUrl);
                }
            }
            Application[] applicationArray = applications.toArray(new Application[applications.size()]);
            return applicationArray;
        }
        finally {
            this.cleanApplicationDir(checkoutPath);
        }
    }

    private void uploadArtifact(String applicationId, File deployArtifact, String deploymentServerUrl) throws ApplicationDeploymentExceptions {
        ApplicationUploadClient applicationUploadClient = new ApplicationUploadClient(deploymentServerUrl);
        UploadedFileItem uploadedFileItem = new UploadedFileItem();
        DataHandler dataHandler = new DataHandler((DataSource)new FileDataSource(deployArtifact));
        uploadedFileItem.setDataHandler(dataHandler);
        uploadedFileItem.setFileName(deployArtifact.getName());
        uploadedFileItem.setFileType("jar");
        UploadedFileItem[] uploadedFileItems = new UploadedFileItem[]{uploadedFileItem};
        String remoteIp = null;
        try {
            URL deploymentURL = new URL(deploymentServerUrl);
            remoteIp = deploymentURL.getHost();
        }
        catch (MalformedURLException e) {
            this.handleException("Deployment server url is malformed.");
        }
        try {
            if (applicationUploadClient.authenticate(this.getAdminUsername(applicationId), appFactoryConfiguration.getFirstProperty("AdminPassword"), remoteIp)) {
                applicationUploadClient.uploadCarbonApp(uploadedFileItems);
                log.info((Object)(deployArtifact.getName() + " is successfully uploaded."));
            } else {
                this.handleException("Failed to login to " + remoteIp + " to deploy artifact:" + deployArtifact.getName());
            }
        }
        catch (Exception e) {
            this.handleException("Failed to upload the artifact:" + deployArtifact + " of application:" + applicationId + " to deployment location:" + deploymentServerUrl);
        }
    }

    private boolean executeMavenGoal(String applicationPath) throws ApplicationDeploymentExceptions {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setShowErrors(true);
        request.setPomFile(new File(applicationPath + File.separator + "pom.xml"));
        ArrayList<String> goals = new ArrayList<String>();
        goals.add("clean");
        goals.add("install");
        request.setGoals(goals);
        DefaultInvoker invoker = new DefaultInvoker();
        SystemOutHandler outputHandler = new SystemOutHandler();
        invoker.setErrorHandler((InvocationOutputHandler)outputHandler);
        String mavenHome = System.getenv("M2_HOME");
        if (mavenHome == null && (mavenHome = System.getenv("M3_HOME")) == null) {
            String msg = "Environment variable either M2_HOME or M3_HOME is not defined";
            log.error((Object)msg);
            throw new ApplicationDeploymentExceptions(msg);
        }
        invoker.setMavenHome(new File(mavenHome));
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExecutionException() == null) {
                if (result.getExitCode() != 0) {
                    request.setOffline(true);
                    result = invoker.execute((InvocationRequest)request);
                    if (result.getExitCode() == 0) {
                        return true;
                    }
                    String errorMessage = "No maven Application found at " + applicationPath;
                    this.handleException(errorMessage);
                }
                return true;
            }
        }
        catch (MavenInvocationException e) {
            this.handleException("Maven invocation failed with error:" + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        return false;
    }

    private void cleanApplicationDir(String applicationPath) {
        File application = new File(applicationPath);
        try {
            FileUtils.deleteDirectory((File)application);
        }
        catch (IOException ignore) {
            log.warn((Object)("Failed to clean up application at path:" + applicationPath));
        }
    }

    private String getAdminUsername(String applicationId) {
        return appFactoryConfiguration.getFirstProperty("AdminUserName") + "@" + applicationId;
    }

    private Map<String, String> getDBParameters(String stage) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String baseKey = "ApplicationDeployment.DeploymentStage" + "." + stage + ".";
        String key = baseKey.concat("databaseUrl");
        String dBURL = appFactoryConfiguration.getFirstProperty(key);
        key = baseKey.concat("databaseUsername");
        String dBUsername = appFactoryConfiguration.getFirstProperty(key);
        key = baseKey.concat("databasePassword");
        String dBPassword = appFactoryConfiguration.getFirstProperty(key);
        parameters.put("databaseUrl", dBURL);
        parameters.put("username", dBUsername);
        parameters.put("password", dBPassword);
        return parameters;
    }
}

